VERSION 1.0 CLASS
BEGIN
  MultiUse = -1  'True
  Persistable = 0  'NotPersistable
  DataBindingBehavior = 0  'vbNone
  DataSourceBehavior  = 0  'vbNone
  MTSTransactionMode  = 0  'NotAnMTSObject
END
Attribute VB_Name = "CDBParser"
Attribute VB_GlobalNameSpace = False
Attribute VB_Creatable = True
Attribute VB_PredeclaredId = False
Attribute VB_Exposed = False
' ----------------------------------------------------------------------------------
' Class Module: CDBParser                                                          '
'                                                                                  '
' Purpose:      The Main engine class containing all db parsing functions.         '
'                                                                                  '
' Usage:                                                                           '
' ----------------------------------------------------------------------------------
Option Explicit

Private m_intFileNumber As Integer
Private m_dblFileTmpPos As Double 'used for moving around within a byte block
Private m_dblFileCurPos As Double 'forward moving counter only
Const m_CAMPAIGNINFO_SIZE_START = 16
Const m_AVTCAMPAIGNINFO_SIZE_START = 20
Const m_AVTCAMPAIGNINFO_START = 24
Const m_CAMPAIGNNAME_START = 65
Const m_CHARACTER_HEADER = "?AVtServCharacter@@"
Const m_MAP_HEADER = "?AVtMetaMapDesc@@"
Const m_MAP_HEX_HEADER = "?AVtMetaMapHex@@"
Const m_SHIP_HEADER = "?AVtShip@@"
Const m_POLITICAL_MATRIX_HEADER = "?AVtPoliticalTensionMatrix@@"
Const m_NEWS_HEADER = "?AVtNewsStory@@"
Const m_PREPARED_MISSIONS_HEADER = "?AVtPreparedMissions@@"
Const m_AUCTION_HEADER = "?AVtAuctionItem@@"
Private m_intAVTCampaignInfoSize As Integer
Private m_dblFileLen As Double
Private m_frmMain As frmMain
'Private m_prgProgress As ccrpProgressBar
Private m_bInitialized As Boolean
Private m_strFileName As String
Private m_intCharacterCnt As Integer
Private m_intAICharCnt As Integer
Private m_dblShipCnt As Double
Private m_dblErrorCnt As Double
Private m_colCharacters As Collection
Private m_AIObject As Boolean
Private m_intAIObjects As Integer
Private m_bHumanFound As Boolean
Private m_eObjectType As eObjectType

Const m_AIHULL_TYPE_MIN_ENUM As Integer = 14 '13 is BB, 14 should be BATS and so on...

Private Enum eObjectType
  eChar = 1
  eShip
  eAuction
  eCampaign
  eNews
  eMissions
  eOther
  eAI
End Enum

'*******************************************************
' PROPERTIES                                           '
'*******************************************************
Public Property Get PlayerCollection() As Collection
  Set PlayerCollection = m_colCharacters
End Property


'*******************************************************
' FUNCTIONS                                            '
'*******************************************************

Public Function Init(ByRef frmMainRef As frmMain, _
                     ByRef prgProgressRef As Object, _
                     FileName As String) As Boolean
  Set m_frmMain = frmMainRef
  'Set m_prgProgress = prgProgressRef
  m_strFileName = FileName
  If Len(FileName) > 1 Then m_bInitialized = True
  
  Set m_colCharacters = New Collection
End Function

Public Function ParseFile(ParseType As String)
  If Not m_bInitialized Then
    MsgBox "Error: Parse engire not intialized", vbCritical
    Exit Function
  End If
  
  PrepFile
  If ParseType = "Full" Then
    ParseFull
  ElseIf ParseType = "Player" Then
    'ParsePlayer
  ElseIf ParseType = "FilterDB" Then
    FilterDB
  End If
End Function

Private Function ParseFull() As Boolean
  ParseAVTCampaignInfo
  While m_dblFileCurPos < m_dblFileLen
    ParseNextObject
  Wend
  m_frmMain.txtStatistics.Text = _
  "Character objects: " & m_intCharacterCnt & vbCrLf & _
  "AI char objects: " & m_intAICharCnt & vbCrLf & _
  "Ship objects: " & m_dblShipCnt & vbCrLf & _
  "Error objects: " & m_dblErrorCnt
  
  Dim iCnt As Integer
  Dim strOut As String
  
  Dim objTemp As CCharacter
  
  For iCnt = 1 To m_colCharacters.Count
    Set objTemp = m_colCharacters.Item(iCnt)
    With objTemp
      strOut = strOut & _
      "Player Name: " & .PlayerName & vbCrLf & _
      "Account Name: " & .AccountName & vbCrLf & _
      "Current Prestige: " & .CurPrestige & vbCrLf & _
      "LifeTime Prestige: " & .LifePrestige & vbCrLf & _
      "Glicko: " & .Glicko & vbCrLf & _
      "Ship Count: " & .ShipCnt & vbCrLf & _
      "Number of accounts: " & .NumAccounts & vbCrLf & vbCrLf
    End With
  Next iCnt
  
  m_frmMain.txtPlayerInfo.Text = strOut
  
End Function

Private Function ParseAVTCampaignInfo() As Boolean
  Dim strTextBuffer As String
  Dim intBufferSize As Integer
  Dim dblMaxBlockSize As Double
  Dim iCnt As Integer
  Dim intNumMissions As Integer
  Dim intNumRaces As Integer
  Dim intUnknown As Integer
  
  'Dim iCnt As Integer
  'Dim arrData() As Byte
  
  'Get object count
  'intBufferSize = Parse32BitBlock(8)
  'strTextBuffer = Space(4)
  'm_dblFileCurPos = 4 + 1
  'Get #m_intFileNumber, m_dblFileCurPos, strTextBuffer
  'm_frmMain.lblObjectCount.Caption = intBufferSize
  'm_dblFileTmpPos = 0
  
  'Add 4 to make sure it starts at the righmost bit of the 32bit block.
  dblMaxBlockSize = Parse32BitBlock(m_CAMPAIGNINFO_SIZE_START + 4)
  'Knock 1 byte off becuase the first byte is binary and we dont' want to read it in.
  intBufferSize = Parse32BitBlock(m_AVTCAMPAIGNINFO_SIZE_START + 4) - 1
  
  'Set current file pointer position to read the block title.
  'We know the first byte is binary so don't read it.
  m_dblFileCurPos = m_AVTCAMPAIGNINFO_SIZE_START + 6
  
  'Make the buffer big enough for the read operation
  strTextBuffer = Space(intBufferSize)
  
  Get #m_intFileNumber, m_dblFileCurPos, strTextBuffer
  
  'Write block header to screen and clear buffer.
  m_frmMain.txtCampaignInfo.Text = strTextBuffer
  strTextBuffer = ""
  
  'Now get campaign name and write it to screen.
  'First get length to use as a buffer size.
  intBufferSize = Parse32BitBlock(m_CAMPAIGNNAME_START)
  strTextBuffer = Space(intBufferSize)
  m_dblFileCurPos = m_CAMPAIGNNAME_START + 1
  Get #m_intFileNumber, m_dblFileCurPos, strTextBuffer
  m_frmMain.txtCampaignInfo.Text = m_frmMain.txtCampaignInfo.Text & _
    vbCrLf & "Campaign Name: " & strTextBuffer
      
  'Now get Campaign Description and write it to screen.
  'First get to use as a buffer size.
  m_dblFileCurPos = m_dblFileCurPos + intBufferSize + 3
  intBufferSize = Parse32BitBlock(m_dblFileCurPos)
  strTextBuffer = Space(intBufferSize)
  m_dblFileCurPos = m_dblFileCurPos + 1
  Get #m_intFileNumber, m_dblFileCurPos, strTextBuffer
  m_frmMain.txtCampaignInfo.Text = m_frmMain.txtCampaignInfo.Text & _
    vbCrLf & "Campaign Description: " & strTextBuffer
    
  'Now get Early Map name and write it to screen.
  'First get length to use as a buffer size.
  m_dblFileCurPos = m_dblFileCurPos + intBufferSize + 3
  intBufferSize = Parse32BitBlock(m_dblFileCurPos)
  strTextBuffer = Space(intBufferSize)
  m_dblFileCurPos = m_dblFileCurPos + 1
  Get #m_intFileNumber, m_dblFileCurPos, strTextBuffer
  m_frmMain.txtCampaignInfo.Text = m_frmMain.txtCampaignInfo.Text & _
    vbCrLf & "Early Map Name: " & strTextBuffer
  
  'Now get Mid Map name and write it to screen.
  'First get length to use as a buffer size.
  m_dblFileCurPos = m_dblFileCurPos + intBufferSize + 3
  intBufferSize = Parse32BitBlock(m_dblFileCurPos)
  strTextBuffer = Space(intBufferSize)
  m_dblFileCurPos = m_dblFileCurPos + 1
  Get #m_intFileNumber, m_dblFileCurPos, strTextBuffer
  m_frmMain.txtCampaignInfo.Text = m_frmMain.txtCampaignInfo.Text & _
    vbCrLf & "Mid Map Name: " & strTextBuffer
  
  'Now get Late Map name and write it to screen.
  'First get length to use as a buffer size.
  m_dblFileCurPos = m_dblFileCurPos + intBufferSize + 3
  intBufferSize = Parse32BitBlock(m_dblFileCurPos)
  strTextBuffer = Space(intBufferSize)
  m_dblFileCurPos = m_dblFileCurPos + 1
  Get #m_intFileNumber, m_dblFileCurPos, strTextBuffer
  m_frmMain.txtCampaignInfo.Text = m_frmMain.txtCampaignInfo.Text & _
    vbCrLf & "Late Map Name: " & strTextBuffer
    
  'Now get all mission names and write them to screen.
  'First get the number of mission (loop counter).
  m_dblFileCurPos = m_dblFileCurPos + intBufferSize + 3
  intNumMissions = Parse32BitBlock(m_dblFileCurPos)
  intBufferSize = 1
  m_frmMain.txtCampaignInfo.Text = m_frmMain.txtCampaignInfo.Text & _
    vbCrLf & "Number of Missions: " & intNumMissions
    
  For iCnt = 1 To intNumMissions
    m_dblFileCurPos = m_dblFileCurPos + intBufferSize + 3
    intBufferSize = Parse32BitBlock(m_dblFileCurPos)
    strTextBuffer = Space(intBufferSize)
    m_dblFileCurPos = m_dblFileCurPos + 1
    Get #m_intFileNumber, m_dblFileCurPos, strTextBuffer
    'Debug.Print strTextBuffer
    m_frmMain.txtCampaignInfo.Text = m_frmMain.txtCampaignInfo.Text & _
      vbCrLf & "Mission" & iCnt & ": " & strTextBuffer
  Next iCnt
  
  'Get race enum info.  Loop and read 32 bit blocks.
  'One block for each race.  No block size indicators.
  m_dblFileCurPos = m_dblFileCurPos + intBufferSize + 3
  intNumRaces = Parse32BitBlock(m_dblFileCurPos)
  
  m_frmMain.txtCampaignInfo.Text = m_frmMain.txtCampaignInfo.Text & _
    vbCrLf & "Number of Races Available: " & intNumRaces
  
  For iCnt = 1 To intNumRaces
    m_dblFileCurPos = m_dblFileCurPos + 4
    intBufferSize = Parse32BitBlock(m_dblFileCurPos)
    'Get #m_intFileNumber, m_dblFileCurPos, strTextBuffer
    m_frmMain.txtCampaignInfo.Text = m_frmMain.txtCampaignInfo.Text & _
      vbCrLf & "Race" & iCnt & ": " & intBufferSize
  Next iCnt
  
  ' Read in next unknown block.  There only seems to be data in the last
  ' 4 bytes so read ahead 8 and parse back 4.
  m_dblFileCurPos = m_dblFileCurPos + 8
  intUnknown = Parse32BitBlock(m_dblFileCurPos)
  
  m_frmMain.txtCampaignInfo.Text = m_frmMain.txtCampaignInfo.Text & _
    vbCrLf & "Unknown Blcok: " & intUnknown
    
  ' Read in repeated campaign name.  Move ahead 12 bytes first to pass over
  ' empty space in prep for reading in campaign name size for the buffer size.
  m_dblFileCurPos = m_dblFileCurPos + 12
  intBufferSize = Parse32BitBlock(m_dblFileCurPos)
  strTextBuffer = Space(intBufferSize)
  m_dblFileCurPos = m_dblFileCurPos + 1
  Get #m_intFileNumber, m_dblFileCurPos, strTextBuffer
  m_frmMain.txtCampaignInfo.Text = m_frmMain.txtCampaignInfo.Text & _
    vbCrLf & "Campaign Name (Repeated): " & strTextBuffer
  m_dblFileCurPos = m_dblFileCurPos + intBufferSize
  
  ' Read in turns passed.
  m_dblFileCurPos = m_dblFileCurPos + 20
  intUnknown = Parse32BitBlock(m_dblFileCurPos)
  m_frmMain.txtCampaignInfo.Text = m_frmMain.txtCampaignInfo.Text & _
    vbCrLf & "Turns Passed: " & intUnknown
  
  ' Read in starting year.
  m_dblFileCurPos = m_dblFileCurPos + 16
  intUnknown = Parse32BitBlock(m_dblFileCurPos)
  m_frmMain.txtCampaignInfo.Text = m_frmMain.txtCampaignInfo.Text & _
    vbCrLf & "Starting Year: " & intUnknown
  
  ' Read in Total accounts made.
  m_dblFileCurPos = m_dblFileCurPos + 16
  intUnknown = Parse32BitBlock(m_dblFileCurPos)
  m_frmMain.txtCampaignInfo.Text = m_frmMain.txtCampaignInfo.Text & _
    vbCrLf & "Total Accounts Made: " & intUnknown
  
  ' Read in Total accounts allowed.
  m_dblFileCurPos = m_dblFileCurPos + 4
  intUnknown = Parse32BitBlock(m_dblFileCurPos)
  m_frmMain.txtCampaignInfo.Text = m_frmMain.txtCampaignInfo.Text & _
    vbCrLf & "Total Accounts Allowed: " & intUnknown
  
  ' Read in Total players logged in.
  m_dblFileCurPos = m_dblFileCurPos + 4
  intUnknown = Parse32BitBlock(m_dblFileCurPos)
  m_frmMain.txtCampaignInfo.Text = m_frmMain.txtCampaignInfo.Text & _
    vbCrLf & "Num Players logged in: " & intUnknown
  
  ' Read in Total players logged max.
  m_dblFileCurPos = m_dblFileCurPos + 4
  intUnknown = Parse32BitBlock(m_dblFileCurPos)
  m_frmMain.txtCampaignInfo.Text = m_frmMain.txtCampaignInfo.Text & _
    vbCrLf & "Num Players logged in Max: " & intUnknown
    
  'Read in game version
  m_dblFileCurPos = m_dblFileCurPos + 4
  intBufferSize = Parse32BitBlock(m_dblFileCurPos)
  strTextBuffer = Space(intBufferSize)
  m_dblFileCurPos = m_dblFileCurPos + 1
  Get #m_intFileNumber, m_dblFileCurPos, strTextBuffer
  m_frmMain.txtCampaignInfo.Text = m_frmMain.txtCampaignInfo.Text & _
    vbCrLf & "Server Version: " & strTextBuffer
  m_dblFileCurPos = m_dblFileCurPos + intBufferSize - 1
  
  
  'Read in game version
  m_dblFileCurPos = m_dblFileCurPos + 4
  intBufferSize = Parse32BitBlock(m_dblFileCurPos)
  strTextBuffer = Space(intBufferSize)
  m_dblFileCurPos = m_dblFileCurPos + 1
  Get #m_intFileNumber, m_dblFileCurPos, strTextBuffer
  m_frmMain.txtCampaignInfo.Text = m_frmMain.txtCampaignInfo.Text & _
    vbCrLf & "Server Version (repeated): " & strTextBuffer
  m_dblFileCurPos = m_dblFileCurPos + intBufferSize
  
  'Advance past some crap...
  m_dblFileCurPos = m_dblFileCurPos - 1
  
End Function

Private Function ParseNextObject() As Boolean
  'Since objects are different size and have differents parse rules,
  ' all we do here is identify the header of the object then let
  ' the object specific routines parse the data and return here
  ' for control.
  'We must assume that the file pointer is at the right spot to begin reading
  ' an object header each time.  Each object header will start with 12 byes.
  ' First 4 are the size of the object, next 4 are the size repeated, next 4
  ' is the length of the header title.  We read that in then pass off to the
  ' appropriate routine.
  Dim intBufferSize As Integer
  Dim strTextBuffer As String
  Dim intNumBuffer As Integer
  Dim intObjectSize As Integer
  Dim dblStaringFilePos As Double
  Dim dblPreObjectReadPos As Double
  Dim bReturn As Boolean
  
  On Error GoTo ObjectError
  
  dblPreObjectReadPos = m_dblFileCurPos
  
  ' Read in object size.
  m_dblFileCurPos = m_dblFileCurPos + 8
  intObjectSize = Parse32BitBlock(m_dblFileCurPos)
  If intObjectSize = 0 Then Stop
  'Read in object header length.
  m_dblFileCurPos = m_dblFileCurPos + 4
  intBufferSize = Parse32BitBlock(m_dblFileCurPos)
  strTextBuffer = Space(intBufferSize - 1)
  m_dblFileCurPos = m_dblFileCurPos + 2
  Get #m_intFileNumber, m_dblFileCurPos, strTextBuffer
  
  dblStaringFilePos = m_dblFileCurPos
  dblPreObjectReadPos = 0
  
  'If m_dblErrorCnt = 7 Then Stop
  
  Select Case strTextBuffer
    Case m_MAP_HEADER
      If Not ParseMap(intObjectSize, strTextBuffer) Then
        m_dblFileCurPos = dblStaringFilePos + intObjectSize - 6
        m_dblErrorCnt = m_dblErrorCnt + 1
      End If
      'Stop
    Case m_CHARACTER_HEADER
      If Not ParseCharacter(intObjectSize, strTextBuffer) Then
        m_dblFileCurPos = dblStaringFilePos + intObjectSize - 6
        m_dblErrorCnt = m_dblErrorCnt + 1
      End If
      DoEvents
    Case m_SHIP_HEADER
        m_dblFileCurPos = dblStaringFilePos + intObjectSize - 6
        m_dblShipCnt = m_dblShipCnt + 1
    '  ParseShip intObjectSize, strTextBuffer
    Case m_POLITICAL_MATRIX_HEADER
      DoEvents
      'Stop
      'Currently just skip the matrix...
      m_dblFileCurPos = m_dblFileCurPos + intObjectSize - 6
    Case m_NEWS_HEADER
      m_dblFileCurPos = dblStaringFilePos + intObjectSize - 6
    Case m_PREPARED_MISSIONS_HEADER
      m_dblFileCurPos = dblStaringFilePos + intObjectSize - 6
    Case Else 'Unknown object
      'ParseUnknown intObjectSize, strTextBuffer
      m_dblErrorCnt = m_dblErrorCnt + 1
      'If m_dblShipCnt = 40920 Or m_dblShipCnt = 58455 Or m_dblShipCnt = 40919 Then Stop
      m_dblFileCurPos = m_dblFileCurPos + intObjectSize - 6
  End Select
  
  Exit Function

ObjectError:
'Simply move file pointer to the end of the object to skip over
' the bad data.
m_dblFileCurPos = dblPreObjectReadPos + dblStaringFilePos + intObjectSize - 6
'm_dblShipCnt = m_dblShipCnt + 1
m_dblErrorCnt = m_dblErrorCnt + 1
  
  
End Function

Private Function PrepFile()
  'Open file for read.
  m_intFileNumber = FreeFile
  
  Open m_strFileName For Binary Access Read As #m_intFileNumber
  m_dblFileLen = FileLen(m_strFileName)
End Function



Private Function Parse32BitBlock(StartPos As Double, _
                                 Optional ByteCnt As Integer = 4) As Long
  ' StartPos should be the rightmost hex pair as we need to read each byte
  ' in reverse order one at a time.
  ' This function will return the converted binary value in decimal as a long.
  ' This function should not effect the "Current File Pointer Position"
  Dim strTemp As String
  Dim intTemp As Integer
  Dim bytTemp As Byte
  Dim dblTemp As Double
  Dim iCnt As Integer
  
  On Error GoTo Parse32BitBlock_ERROR
    
  'Start at the known position of the first block count for the campaign
  ' info section.
  m_dblFileTmpPos = StartPos
  
  'Start reading at the 4th byte and read backwards for 4 bytes
  For iCnt = ByteCnt To 1 Step -1
    Get #m_intFileNumber, m_dblFileTmpPos, bytTemp
    'Decrement file pointer position to read the byte in reverse order
    m_dblFileTmpPos = m_dblFileTmpPos - 1
    'Shift place variable 8 bits to the left to make room for the new byte
    dblTemp = dblTemp * 2 ^ 8
    'Combine the place holder with the new byte.  New byte is added to the
    ' 8 rightmost bits.
    dblTemp = (dblTemp Xor bytTemp)
  Next iCnt
  
  'Return converted value.
  Parse32BitBlock = dblTemp
  
  Exit Function
  
Parse32BitBlock_ERROR:
  
End Function

Private Function ParseCharacter(ObjectSize As Integer, _
                                ObjectName As String) As Boolean
  Dim intUnknown As Integer
  Dim intBufferSize As Integer
  Dim strTextBuffer As String
  Dim intNumBuffer As Integer
  Dim intObjectSize As Integer
  Dim intShipCnt As Integer
  Dim iCnt As Integer
  Dim lGlicko As Long
  Dim lCurPrestige As Long
  Dim lLifePrestige As Long
  Dim lStartPos As Long
  Dim objCharacter As New CCharacter
  Dim intHullEnum As Integer
  
  On Error GoTo ParseCharacter_ERROR
  
  'Default to true.
  ParseCharacter = True
                                  
  'Error check for object header name.
  If ObjectName <> m_CHARACTER_HEADER Then
    ParseCharacter = False
    Exit Function
  End If
  
  lStartPos = m_dblFileCurPos
  
  With objCharacter
    'Write object header
    'm_frmMain.txtPlayerInfo.Text = m_frmMain.txtPlayerInfo.Text & _
    '  vbCrLf & vbCrLf & m_CHARACTER_HEADER
    
    
    'First get the ship count for the character.
    m_dblFileCurPos = m_dblFileCurPos + 29 + Len(m_CHARACTER_HEADER)
    intShipCnt = Parse32BitBlock(m_dblFileCurPos)
    If intShipCnt = 0 Then
      'Stop
      ParseCharacter = False
      Exit Function
    End If
    
    .ShipCnt = intShipCnt
        
    'm_frmMain.txtPlayerInfo.Text = m_frmMain.txtPlayerInfo.Text & _
    '  vbCrLf & "Ship Count: " & intShipCnt
    
    'Get hull type enum.  Should always be in the same place.
    'This enum should match up against economy.gf
    m_dblFileCurPos = m_dblFileCurPos + 22
    intHullEnum = Parse32BitBlock(m_dblFileCurPos)
    
    'This sets the flag that determines if it is AI or not.
    'Only set this flag for Bases and Planets.  All other AI
    ' can be removed.
    
    
    'Move to end of first ship type length value.
    m_dblFileCurPos = m_dblFileCurPos + 4
    
    For iCnt = 1 To intShipCnt
      ' Read in length of ship type.
      intBufferSize = Parse32BitBlock(m_dblFileCurPos)
      strTextBuffer = Space(intBufferSize)
      Get #m_intFileNumber, m_dblFileCurPos + 1, strTextBuffer
      'm_frmMain.txtPlayerInfo.Text = m_frmMain.txtPlayerInfo.Text & _
      '  vbCrLf & "Ship" & iCnt & " Type: " & strTextBuffer
      'move pointer to the end of the type + 8 bytes to read in lenght
      ' of the ship name.
      If iCnt = 1 Then
        .Ship1Type = strTextBuffer
      ElseIf iCnt = 2 Then
        .Ship2Type = strTextBuffer
      ElseIf iCnt = 3 Then
        .Ship3Type = strTextBuffer
      End If
      m_dblFileCurPos = m_dblFileCurPos + intBufferSize + 8
      intBufferSize = Parse32BitBlock(m_dblFileCurPos)
      strTextBuffer = Space(intBufferSize)
      Get #m_intFileNumber, m_dblFileCurPos + 1, strTextBuffer
      'm_frmMain.txtPlayerInfo.Text = m_frmMain.txtPlayerInfo.Text & _
      '  vbCrLf & "Ship" & iCnt & " Name: " & strTextBuffer
        
      If iCnt = 1 Then
        .Ship1Name = strTextBuffer
      ElseIf iCnt = 2 Then
        .Ship2Name = strTextBuffer
      ElseIf iCnt = 3 Then
        .Ship3Name = strTextBuffer
      End If
        
      'move to read the next ship type size only if we have more ships to read.
      If iCnt <> intShipCnt Then
        m_dblFileCurPos = m_dblFileCurPos + 30 + intBufferSize
      Else 'put it to the end of the last block read.
        m_dblFileCurPos = m_dblFileCurPos + intBufferSize
      End If
    Next iCnt
    
    'Determine race
    Select Case Mid(.Ship1Type, 1, 1)
      Case "F"
        .Race = "Federation"
      Case "K"
        .Race = "Klingon"
      Case "H"
        .Race = "Hydran"
      Case "G"
        .Race = "Gorn"
      Case "L"
        .Race = "Lyran"
      Case "Z"
        .Race = "Mirak"
      Case "I"
        .Race = "ISC"
      Case "R"
        .Race = "Romulan"
    End Select
    
    'Read in character name (size first..)
    m_dblFileCurPos = m_dblFileCurPos + 8
    intBufferSize = Parse32BitBlock(m_dblFileCurPos)
    strTextBuffer = Space(intBufferSize)
    Get #m_intFileNumber, m_dblFileCurPos + 1, strTextBuffer
    'm_frmMain.txtPlayerInfo.Text = m_frmMain.txtPlayerInfo.Text & _
    '  vbCrLf & "Player Game Name: " & strTextBuffer
    m_dblFileCurPos = m_dblFileCurPos + intBufferSize
    
    .PlayerName = strTextBuffer
    
    'DEBUG
    'If InStr(1, .PlayerName, "squiggy") Then Stop
      
    'Get Glicko.
    m_dblFileCurPos = m_dblFileCurPos + 4
    lGlicko = Parse32BitBlock(m_dblFileCurPos)
    'm_frmMain.txtPlayerInfo.Text = m_frmMain.txtPlayerInfo.Text & _
    '  vbCrLf & "Glicko: " & lGlicko
    
    .Glicko = lGlicko
      
    'Get current prestige.
    m_dblFileCurPos = m_dblFileCurPos + 4
    lCurPrestige = Parse32BitBlock(m_dblFileCurPos)
    'm_frmMain.txtPlayerInfo.Text = m_frmMain.txtPlayerInfo.Text & _
    '  vbCrLf & "Current Prestige: " & lCurPrestige
    
    .CurPrestige = lCurPrestige
      
    'Get lifetime prestige.
    m_dblFileCurPos = m_dblFileCurPos + 4
    lLifePrestige = Parse32BitBlock(m_dblFileCurPos)
    'm_frmMain.txtPlayerInfo.Text = m_frmMain.txtPlayerInfo.Text & _
    '  vbCrLf & "LifeTime Prestige: " & lLifePrestige
      
    .LifePrestige = lLifePrestige
      
    'Verify the type of character.  AI will stop after prestige.
    If (m_dblFileCurPos - lStartPos) + 68 = ObjectSize Then
      
      'Set pointer to end of current object and end
      
      'm_AIObject = True 'Set flag so we skip this object on the filter function.
      
      m_dblFileCurPos = m_dblFileCurPos + 62
      m_intAICharCnt = m_intAICharCnt + 1
      m_eObjectType = eAI
      
      'Only set the flag if the AI is NOT a planet or base as
      ' we want to keep all bases and planets in the database!!
      If intHullEnum >= m_AIHULL_TYPE_MIN_ENUM Then
        'Debug.Print "False AI: " & intHullEnum
        m_AIObject = False
      Else
        'Debug.Print "True AI: " & intHullEnum
        m_AIObject = True
      End If
  '    Stop
    
    Else
      'm_AIObject = True 'Set flag so we skip this object on the filter function.
      'm_bHumanFound = True
      m_AIObject = False
      m_eObjectType = eChar
      'Debug.Print "Human : " & intHullEnum

      m_intCharacterCnt = m_intCharacterCnt + 1
      'Get account login name.
      m_dblFileCurPos = m_dblFileCurPos + 66
      intBufferSize = Parse32BitBlock(m_dblFileCurPos)
      strTextBuffer = Space(intBufferSize)
      Get #m_intFileNumber, m_dblFileCurPos + 1, strTextBuffer
      'm_frmMain.txtPlayerInfo.Text = m_frmMain.txtPlayerInfo.Text & _
      '  vbCrLf & "Player Account Name: " & strTextBuffer
      m_dblFileCurPos = m_dblFileCurPos + intBufferSize
      
      .AccountName = strTextBuffer
      
      'Get account IP.
      m_dblFileCurPos = m_dblFileCurPos + 8
      intBufferSize = Parse32BitBlock(m_dblFileCurPos)
      strTextBuffer = Space(intBufferSize)
      Get #m_intFileNumber, m_dblFileCurPos + 1, strTextBuffer
      'm_frmMain.txtPlayerInfo.Text = m_frmMain.txtPlayerInfo.Text & _
      '  vbCrLf & "Player Account IP Address: " & strTextBuffer
        
      .IP = strTextBuffer
        
      'Set pointer to the end of this object for the next read process.
      m_dblFileCurPos = m_dblFileCurPos + intBufferSize + 43
      
      'If we get an error trying to add then we have a duplicate.
      'This will only be from old databases as all new bad player
      ' records will have been deleted.  So simply add up the stats
      ' for this player.
      On Error GoTo DuplicatePlayer_ERROR
      m_colCharacters.Add objCharacter, .AccountName
      Set objCharacter = Nothing
    
    End If
  End With
  
  Exit Function
  
DuplicatePlayer_ERROR:
  'Add up stats to current object.
  'Stop
  Dim objTempChar As New CCharacter
  With objCharacter
    Set objTempChar = m_colCharacters.Item(.AccountName)
    .CurPrestige = .CurPrestige + objTempChar.CurPrestige
    .LifePrestige = .LifePrestige + objTempChar.LifePrestige
    .Glicko = .Glicko + objTempChar.Glicko
    .NumAccounts = (.NumAccounts + 1)
  End With
  Set objTempChar = Nothing
  Set objCharacter = Nothing
  Exit Function
  
ParseCharacter_ERROR:
  ParseCharacter = False
  
End Function

Private Function ParseMap(ObjectSize As Integer, _
                          ObjectName As String) As Boolean

                          
  Dim intUnknown As Integer
  Dim intBufferSize As Integer
  Dim strTextBuffer As String
  Dim intNumBuffer As Integer
  Dim intObjectSize As Integer
  Dim intColCnt As Integer
  Dim intRowCnt As Integer
  Dim iCnt As Integer
  Dim intHexCnt As Integer

  On Error GoTo ParseMap_ERROR
  
  'Default to true.
  ParseMap = True
                          
  'Error check for object header name.
  If ObjectName <> m_MAP_HEADER Then
    ParseMap = False
    Exit Function
  End If
  
  'Write object header
  m_frmMain.txtMapInfo.Text = m_MAP_HEADER

  'Get column count (base1).
  m_dblFileCurPos = m_dblFileCurPos + 21 + Len(m_MAP_HEADER)
  intColCnt = Parse32BitBlock(m_dblFileCurPos)
  'm_frmMain.txtMapInfo.Text = m_frmMain.txtMapInfo.Text & _
  '  vbCrLf & "Column Count: " & intColCnt

  'Get row count (base1).
  m_dblFileCurPos = m_dblFileCurPos + 4
  intRowCnt = Parse32BitBlock(m_dblFileCurPos)
  'm_frmMain.txtMapInfo.Text = m_frmMain.txtMapInfo.Text & _
  '  vbCrLf & "Row Count: " & intRowCnt
    
  'Calculate total hex count.
  intHexCnt = intColCnt * intRowCnt
  'm_frmMain.txtMapInfo.Text = m_frmMain.txtMapInfo.Text & _
  '  vbCrLf & "Total hexes: " & intHexCnt
    
  'Parse each hex one at a time.
  m_dblFileCurPos = m_dblFileCurPos + 1
  For iCnt = 1 To intHexCnt
    DoEvents
    ParseMapHex iCnt
  Next iCnt
  
  Exit Function
  
ParseMap_ERROR:
  ParseMap = False

End Function

Private Function ParseShip(ObjectSize As Integer, _
                           ObjectName As String) As Boolean
                                  
  'Error check for object header name.
  If ObjectName <> m_SHIP_HEADER Then
    ParseShip = False
    Exit Function
  End If
  
  Dim intUnknown As Integer
  Dim intBufferSize As Integer
  Dim strTextBuffer As String
  Dim intNumBuffer As Integer
  Dim intObjectSize As Integer
  Dim intShipCnt As Integer
  Dim iCnt As Integer
  Dim lGlicko As Long
  Dim lCurPrestige As Long
  Dim lLifePrestige As Long
  
End Function


Private Function ParseMapHex(HexNumber As Integer) As Boolean
                                  
  Dim intUnknown As Integer
  Dim intBufferSize As Integer
  Dim strTextBuffer As String
  Dim intNumBuffer As Integer
  Dim intObjectSize As Integer
  Dim intShipCnt As Integer
  Dim iCnt As Integer
  Dim dblTemp As Double
  Dim intRowCnt As Integer
  Dim intColCnt As Integer
  
  m_dblFileCurPos = m_dblFileCurPos + 29 - (Len(m_MAP_HEX_HEADER) + 1)
  
  'Get object header.
  'm_dblFileCurPos = m_dblFileCurPos + 8
  intBufferSize = Parse32BitBlock(m_dblFileCurPos)
  strTextBuffer = Space(intBufferSize - 1)
  Get #m_intFileNumber, m_dblFileCurPos + 2, strTextBuffer
  m_dblFileCurPos = m_dblFileCurPos + Len(m_MAP_HEX_HEADER) + 1
  
  If strTextBuffer <> m_MAP_HEX_HEADER Then
    MsgBox "Error reading in ParseMapHex", vbCritical
    ParseMapHex = False
    Exit Function
  End If
  
  'Write object header
  If HexNumber = 1 Then
    'm_frmMain.txtMapInfo.Text = m_MAP_HEX_HEADER
  Else
    'm_frmMain.txtMapInfo.Text = m_frmMain.txtMapInfo.Text & vbCrLf & vbCrLf & m_MAP_HEX_HEADER
  End If
  
  'Write hex number (from total).
  'm_frmMain.txtMapInfo.Text = m_frmMain.txtMapInfo.Text & vbCrLf & "Hex Number: " & HexNumber

  'Spit out the data one byte at a time.
  'For iCnt = 1 To 23
  '  m_dblFileCurPos = m_dblFileCurPos + 1
  '  dblTemp = Parse32BitBlock(m_dblFileCurPos, 1)
  '  m_frmMain.txtMapInfo.Text = m_frmMain.txtMapInfo.Text & _
  '    vbCrLf & "Value" & iCnt & ": " & dblTemp
  '  'If m_dblFileCurPos > 1375 Then Exit For
  'Next iCnt
  
  'Skip the above section of unknown data
  m_dblFileCurPos = m_dblFileCurPos + 23
  
  'Read in hex row cnt (base 0)
  m_dblFileCurPos = m_dblFileCurPos + 4
  intRowCnt = Parse32BitBlock(m_dblFileCurPos)
  'm_frmMain.txtMapInfo.Text = m_frmMain.txtMapInfo.Text & _
  '  vbCrLf & "Row Count: " & intRowCnt
  
  'Read in hex col cnt (base 0)
  m_dblFileCurPos = m_dblFileCurPos + 4
  intColCnt = Parse32BitBlock(m_dblFileCurPos)
  'm_frmMain.txtMapInfo.Text = m_frmMain.txtMapInfo.Text & _
  '  vbCrLf & "Column Count: " & intColCnt
    
  'Write out hex pos (as it would be on the map in game)
  'm_frmMain.txtMapInfo.Text = m_frmMain.txtMapInfo.Text & _
  '  vbCrLf & "Map position (in game): " & (intRowCnt + 1) & "/" & (intColCnt + 1)
  
  'Read in unknown values.
  'For iCnt = 1 To 16
  'm_dblFileCurPos = m_dblFileCurPos + 1
  'intUnknown = Parse32BitBlock(m_dblFileCurPos, 1)
  'm_frmMain.txtMapInfo.Text = m_frmMain.txtMapInfo.Text & _
  '  vbCrLf & "Unknown Value" & iCnt & ": " & intUnknown
  'Next iCnt
  
  'Skip the above section of unknown data
  m_dblFileCurPos = m_dblFileCurPos + 16
    
  'Read in economy
  m_dblFileCurPos = m_dblFileCurPos + 4
  intNumBuffer = Parse32BitBlock(m_dblFileCurPos)
  'm_frmMain.txtMapInfo.Text = m_frmMain.txtMapInfo.Text & _
  '  vbCrLf & "Economy: " & intNumBuffer
  
  'Read in economy
  m_dblFileCurPos = m_dblFileCurPos + 4
  intNumBuffer = Parse32BitBlock(m_dblFileCurPos)
  'm_frmMain.txtMapInfo.Text = m_frmMain.txtMapInfo.Text & _
  '  vbCrLf & "Economy: " & intNumBuffer
    
  'Read in Strength
  m_dblFileCurPos = m_dblFileCurPos + 4
  intNumBuffer = Parse32BitBlock(m_dblFileCurPos)
  'm_frmMain.txtMapInfo.Text = m_frmMain.txtMapInfo.Text & _
  '  vbCrLf & "Strength: " & intNumBuffer
  
  'Read in Strength
  m_dblFileCurPos = m_dblFileCurPos + 4
  intNumBuffer = Parse32BitBlock(m_dblFileCurPos)
  'm_frmMain.txtMapInfo.Text = m_frmMain.txtMapInfo.Text & _
  '  vbCrLf & "Strength: " & intNumBuffer
  
  'Read in unknown values.
  'For iCnt = 1 To 16
  'm_dblFileCurPos = m_dblFileCurPos + 1
  'intUnknown = Parse32BitBlock(m_dblFileCurPos, 1)
  'm_frmMain.txtMapInfo.Text = m_frmMain.txtMapInfo.Text & _
  '  vbCrLf & "Unknown Value" & iCnt & ": " & intUnknown
  'Next iCnt
  
  'Skip the above section of unknown data
  m_dblFileCurPos = m_dblFileCurPos + 16
  
'  Stop
  
End Function

Private Function ParseUnknown(ObjectSize As Integer, _
                              ObjectName As String) As Boolean
                                  
  'Dim intUnknown As Integer
  'Dim intBufferSize As Integer
  'Dim strTextBuffer As String
  'Dim intNumBuffer As Integer
  'Dim intObjectSize As Integer
  'Dim intShipCnt As Integer
  'Dim iCnt As Integer
  'Dim dblTemp As Double
  'Dim intRowCnt As Integer
  'Dim intColCnt As Integer
  
  'We will simply skip the unknown object.
  Stop
  'm_dblFileCurPos = m_dblFileCurPos + ObjectSize


End Function
Private Function FilterDB()
  Dim strTemp As String
  Dim intTemp As Integer
  Dim bytTemp As Byte
  Dim dblTemp As Double
  Dim iCnt As Double
  Dim dblFileTmpPos As Double
  Dim intFileNumber As Integer
  Dim FromPos As Double
  Dim ToPos As Double
  Dim dblPos As Double
  Dim colArr As Collection
  Dim colChars As Collection
  Dim colAIChars As Collection
  Dim colShips As Collection
  Dim colOther As Collection
  Dim colRemoved As Collection
  Dim arrObj() As Byte
  Dim objCount As Double
  Dim bAddObject As Boolean
  Dim iCnt1 As Integer
  Dim iCnt2 As Integer
  Dim iCnt3 As Integer
  Dim iCnt4 As Integer
  Dim iCnt5 As Integer
  
  Set colArr = New Collection
  Set colChars = New Collection
  Set colAIChars = New Collection
  Set colShips = New Collection
  Set colOther = New Collection
  Set colRemoved = New Collection
  'm_bHumanFound = False
  
  If m_frmMain.chkMessage.Value = 0 Then
    MsgBox "Starting Clean.  Please wait for next message box..."
  End If
  
  dblFileTmpPos = 1
    
  'Get first part of the database. Up to and including the political matrix
  ' in a single array since we want to keep all of it.
  ParseAVTCampaignInfo
  
  'Write out campaign info to new file...
  FromPos = 1
  ReDim arrObj(1 To m_dblFileCurPos)
  Get #m_intFileNumber, FromPos, arrObj()
  
  'Add campaign block to collection
  colArr.Add arrObj, "campaign"
  
  'Save next starting pos to write next object if valid.
  FromPos = m_dblFileCurPos + 1
  m_AIObject = False 'initialize
  
  
  Dim intNotAdded As Integer
  intNotAdded = 0
  'Start looping through each object, save if flagged to save based
  ' on many flags set in "FilterNextObject"
  While m_dblFileCurPos < m_dblFileLen
      FilterNextObject
      iCnt = 1
      ReDim arrObj(1 To (m_dblFileCurPos - FromPos))
      Get #m_intFileNumber, FromPos, arrObj()
      objCount = objCount + 1
      
      If m_AIObject = False Then
        Select Case m_eObjectType
          Case eObjectType.eCampaign
            colArr.Add arrObj, CStr(colArr.Count + 1) & ""
            
          Case eObjectType.eChar
            colChars.Add arrObj, CStr(colChars.Count + 1) & ""
            
          Case eObjectType.eShip
            colShips.Add arrObj, CStr(colShips.Count + 1) & ""
            
          Case eObjectType.eAI
            colAIChars.Add arrObj, CStr(colAIChars.Count + 1) & ""
            
          Case eObjectType.eAuction
            colOther.Add arrObj, CStr(colOther.Count + 1) & ""
            'Stop
            
          Case Else
            colOther.Add arrObj, CStr(colOther.Count + 1) & ""
            
        End Select
      Else
        colRemoved.Add arrObj, CStr(colRemoved.Count + 1) & ""
      End If
          
      FromPos = m_dblFileCurPos
      m_frmMain.lblFilePos.Caption = FromPos
      m_frmMain.lblObjectCount.Caption = colRemoved.Count
      'Debug.Print FromPos
      m_AIObject = False 'initialize
          
    'End If
  Wend
    
  'Display stats.
  With m_frmMain
    .lblObjectCount.Caption = colRemoved.Count
    .txtStatistics.Text = "Campaign objects (not accurate): " & colArr.Count & vbCrLf & _
      "Human Character Objects: " & colChars.Count & vbCrLf & _
      "AI Character Objects: " & colAIChars.Count & vbCrLf & _
      "Ship Objects: " & colShips.Count & vbCrLf & _
      "Other (Auction etc.. ): " & colOther.Count & vbCrLf & vbCrLf & _
      "REMOVED: " & colRemoved.Count
    
  End With
  
  Dim intRem As Integer
  intRem = colRemoved.Count
  
  m_frmMain.lblCharcnt.Caption = intRem
  
  If m_frmMain.chkMessage.Value = 0 Then
    MsgBox colRemoved.Count & " Objects removed.  Removing ships next..."
  End If
  

  
  'Remove all uneeded ships.
  Set colShips = RemoveShips(colChars, colAIChars, colShips, colRemoved)

  m_frmMain.lblShipCnt.Caption = colRemoved.Count - intRem
   
  If m_frmMain.chkMessage.Value = 0 Then
    MsgBox "Ship removal complete.  Saving to file..."
  End If
  
  intFileNumber = FreeFile
  'Dim intTemp As Integer
  'intTemp = 5
  
  Open "dbout.sds" For Binary Access Write As #intFileNumber
  'Open "chars.sds" For Binary Access Write As #intTemp
  
  Dim objTemp As Object
  Dim arr() As Byte
  
  'Save campaign info first!!
  For iCnt = 1 To colArr.Count
    arr() = colArr(iCnt)
    Put #intFileNumber, , arr()
  Next
    
  'Save human chars next.
  For iCnt = 1 To colChars.Count
    arr() = colChars(iCnt)
    Put #intFileNumber, , arr()
    'Put #intTemp, , arr()
  Next
  
  'Save AI chars next.
  For iCnt = 1 To colAIChars.Count
    arr() = colAIChars(iCnt)
    Put #intFileNumber, , arr()
  Next
  
  'Save all ships last.
  For iCnt = 1 To colShips.Count
    arr() = colShips(iCnt)
    Put #intFileNumber, , arr()
    'Put #intTemp, , arr()
  Next
    
  'Last, save all other items (auctions)
  For iCnt = 1 To colOther.Count
    arr() = colOther(iCnt)
    Put #intFileNumber, , arr()
  Next
    
  
  Close #intFileNumber
  Close #m_intFileNumber
  'Close #intTemp
  
  'Now save deleted objects for reference.
  Open "deleted_objects.sds" For Binary Access Write As #intFileNumber
  
  For iCnt = 1 To colRemoved.Count
    arr() = colRemoved(iCnt)
    Put #intFileNumber, , arr()
  Next
  
  Close #intFileNumber
  
  'DONE.  NOTIFY USER!!
  
  MsgBox "Saved to dbout.sds.  You must now manually deduct the deleted objects from the object count, " & _
    "rename the file and place it in the autosave folder then start up the server."
  
End Function
Private Function FilterNextObject()
  'Since objects are different size and have differents parse rules,
  ' all we do here is identify the header of the object then let
  ' the object specific routines parse the data and return here
  ' for control.
  'We must assume that the file pointer is at the right spot to begin reading
  ' an object header each time.  Each object header will start with 12 byes.
  ' First 4 are the size of the object, next 4 are the size repeated, next 4
  ' is the length of the header title.  We read that in then pass off to the
  ' appropriate routine.
  Dim intBufferSize As Integer
  Dim strTextBuffer As String
  Dim intNumBuffer As Integer
  Dim intObjectSize As Integer
  Dim dblStaringFilePos As Double
  Dim dblPreObjectReadPos As Double
  Dim bReturn As Boolean
  
  On Error GoTo ObjectError
  
  dblPreObjectReadPos = m_dblFileCurPos
  
  ' Read in object size.
  m_dblFileCurPos = m_dblFileCurPos + 8
  intObjectSize = Parse32BitBlock(m_dblFileCurPos)
  If intObjectSize = 0 Then MsgBox "Error in FilterNextObject function"
  'Read in object header length.
  m_dblFileCurPos = m_dblFileCurPos + 4
  intBufferSize = Parse32BitBlock(m_dblFileCurPos)
  strTextBuffer = Space(intBufferSize - 1)
  m_dblFileCurPos = m_dblFileCurPos + 2
  Get #m_intFileNumber, m_dblFileCurPos, strTextBuffer
  
  dblStaringFilePos = m_dblFileCurPos
  dblPreObjectReadPos = 0
  
  'If m_dblErrorCnt = 7 Then Stop
  
  Select Case strTextBuffer
    Case m_MAP_HEADER
      m_eObjectType = eCampaign
      If Not ParseMap(intObjectSize, strTextBuffer) Then
        m_dblFileCurPos = dblStaringFilePos + intObjectSize - 6
        m_dblErrorCnt = m_dblErrorCnt + 1
      End If
      'Stop
    Case m_CHARACTER_HEADER
      
      If ParseCharacter(intObjectSize, strTextBuffer) Then
        'm_dblFileCurPos = dblStaringFilePos + intObjectSize - 6
        'm_dblErrorCnt = m_dblErrorCnt + 1
'        If m_AIObject = False And m_bHumanFound = False Then
'          m_bHumanFound = True
'        Else
'          m_AIObject = True
'        End If
      Else
        m_dblFileCurPos = dblStaringFilePos + intObjectSize - 6
        'm_AIObject = True
      End If
      DoEvents
      'If intObjectSize > 300 Then
      '  m_AIObject = False
      '  m_bHumanFound = True
      'Else
      '  m_AIObject = True
      'End If
      'm_dblFileCurPos = dblStaringFilePos + intObjectSize - 6
    
    Case m_SHIP_HEADER
      m_eObjectType = eShip
      'ParseShip intObjectSize, strTextBuffer
      m_dblFileCurPos = m_dblFileCurPos + intObjectSize - 6
    
    Case m_POLITICAL_MATRIX_HEADER
      m_eObjectType = eCampaign
      DoEvents
      'Stop
      'Currently just skip the matrix...
      m_dblFileCurPos = m_dblFileCurPos + intObjectSize - 6
    
    Case m_NEWS_HEADER
      m_eObjectType = eNews
      m_dblFileCurPos = m_dblFileCurPos + intObjectSize - 6
      m_AIObject = True
    
    Case m_PREPARED_MISSIONS_HEADER
      m_eObjectType = eMissions
      m_dblFileCurPos = m_dblFileCurPos + intObjectSize - 6
      m_AIObject = True
    
    Case m_AUCTION_HEADER
      m_eObjectType = eAuction
      m_dblFileCurPos = m_dblFileCurPos + intObjectSize - 6
    
    Case Else 'Unknown object
      m_eObjectType = eOther
      'ParseUnknown intObjectSize, strTextBuffer
      'm_dblShipCnt = m_dblShipCnt + 1
      'If m_dblShipCnt = 40920 Or m_dblShipCnt = 58455 Or m_dblShipCnt = 40919 Then Stop
      m_dblFileCurPos = m_dblFileCurPos + intObjectSize - 6

    

  End Select
  
  Exit Function

ObjectError:
'Simply move file pointer to the end of the object to skip over
' the bad data.
Stop
m_dblFileCurPos = dblPreObjectReadPos + dblStaringFilePos + intObjectSize - 6
m_dblShipCnt = m_dblShipCnt + 1
m_dblErrorCnt = m_dblErrorCnt + 1
End Function

Private Function RemoveShips(ByRef HumanCharColl As Collection, _
                              ByRef AICharColl As Collection, _
                              ByRef ShipsColl As Collection, _
                              ByRef RemovedColl As Collection) As Collection
  'Search both the HumanChar collection and AIChar collection for ships
  ' in the Ships collection.  If not match if found then remove the ship
  ' from the ship collection and place it in the Removed collection so
  ' it is not saved to the new database file.
  'RETURNS NEW SHIP COLLECTION WITH CRAP REMOVED!
  Dim iCnt As Integer
  Dim iCnt2 As Integer
  Dim arr() As Byte
  Dim arr2() As Byte
  Dim tmpShipID As Double
  Dim tmpCharID As Double
  Dim newShips As Collection
  Dim lngShipCnt As Long
  
  Set newShips = New Collection
  
  lngShipCnt = ShipsColl.Count
  
  'Loop through each ship in the collection.
  For iCnt = 1 To lngShipCnt
    m_frmMain.lblShiptCnt.Caption = iCnt & " of " & lngShipCnt
    m_frmMain.lblShiptCnt.Refresh
    arr() = ShipsColl(iCnt)
    tmpShipID = ExtractObjectID(arr(), True)
    'loop through each human char object looking for a match.
    For iCnt2 = 1 To HumanCharColl.Count
      arr2() = HumanCharColl(iCnt2)
      tmpCharID = ExtractObjectID(arr2(), False)
      If tmpCharID = tmpShipID Then
        Exit For
      End If
    Next
    If iCnt2 <= HumanCharColl.Count Then
      'match found, add to collection to save.
      newShips.Add arr(), CStr(newShips.Count + 1)
    Else
      'Look for match in the AI collection
      For iCnt2 = 1 To AICharColl.Count
        arr2() = AICharColl(iCnt2)
        tmpCharID = ExtractObjectID(arr2(), False)
        If tmpCharID = tmpShipID Then
          Exit For
        End If
      Next
      If iCnt2 < AICharColl.Count Then
        'match found, add to collection to save.
        newShips.Add arr(), CStr(newShips.Count + 1)
        
      Else
        'No match.  Stick in removed collection.
        RemovedColl.Add arr(), CStr(RemovedColl.Count + 1)
        'Update removed object count label
        m_frmMain.lblObjectCount.Caption = RemovedColl.Count
        m_frmMain.lblObjectCount.Refresh
      End If
    End If

  Next
  
  Set RemoveShips = newShips

End Function

Private Function ExtractObjectID(ByRef ByteArray() As Byte, IsShip As Boolean) As Double
  'Parse the array to extract the ID and return it.
  Dim bytTemp As Byte
  Dim dblTemp As Double
  Dim iCnt As Integer
  Dim iOffset As Integer
  
  'Set offset based on object type
  If IsShip Then
    iOffset = 47
  Else
    iOffset = 43
  End If
  
  'Start reading at the 4th byte and read backwards for 4 bytes
  For iCnt = 4 To 1 Step -1
    bytTemp = ByteArray(iCnt + iOffset)
    'Shift place variable 8 bits to the left to make room for the new byte
    dblTemp = dblTemp * 2 ^ 8
    'Combine the place holder with the new byte.  New byte is added to the
    ' 8 rightmost bits.
    dblTemp = (dblTemp Xor bytTemp)
  Next iCnt
  
  ExtractObjectID = dblTemp
End Function
                              

