VERSION 1.0 CLASS
BEGIN
  MultiUse = -1  'True
  Persistable = 0  'NotPersistable
  DataBindingBehavior = 0  'vbNone
  DataSourceBehavior  = 0  'vbNone
  MTSTransactionMode  = 0  'NotAnMTSObject
END
Attribute VB_Name = "CWSIFalconBase"
Attribute VB_GlobalNameSpace = False
Attribute VB_Creatable = True
Attribute VB_PredeclaredId = False
Attribute VB_Exposed = False
Attribute VB_Ext_KEY = "SavedWithClassBuilder6" ,"Yes"
Attribute VB_Ext_KEY = "Top_Level" ,"Yes"
' ----------------------------------------------------------------------------------
' Class Module: CWSIFalconBase                                                     '
'                                                                                  '
' Purpose:      Controls access to the database through IPro Falcon                '
'                                                                                  '
' Usage:                                                                           '
' ----------------------------------------------------------------------------------

Option Explicit
'========================== API Declarations ========================

'=========================== Enumerations ===========================

'============================ Constants =============================

' ----------------------------------------------------------------------------------
'Module Level Variables                                                            '
' ----------------------------------------------------------------------------------
Private WithEvents m_oFalcon As FALCONWNLib.Falcon
Attribute m_oFalcon.VB_VarHelpID = -1
Private m_strLastFalconError As String
Private m_xaResults As XArrayDB


'************************
'  P R O P E R T I E S  *
'************************

Public Property Get Result() As XArrayDB
  Set Result = m_xaResults
End Property

Public Property Get LastError() As String
  LastError = m_strLastFalconError
End Property


'****************
'  E V E N T S  *
'****************

' This event is fired when the status of the internet connection
' changes. It will have values such as "Finding host", "Host found",
' "Connecting", "Receiving response", "Closing connection", etc.
Private Sub m_ofalcon_StatusUpdate(ByVal strStatus As String)
    Debug.Print "Falcon Status: " & strStatus
End Sub

' This event is fired when an IPro Falcon error occurs (such as invalid SQL,
' database connection lost, network connection lost, etc.)
Private Sub m_ofalcon_TCPError(ByVal strError As String)
    m_strLastFalconError = strError
End Sub

Private Sub Class_Initialize()
    ' create the Falcon object -- it will last the lifetime of the program
    Set m_oFalcon = New FALCONWNLib.Falcon
End Sub

Private Sub Class_Terminate()
    ' release the falcon object
    Set m_oFalcon = Nothing
End Sub


'*******************************
'  P U B L I C  M E T H O D S  *
'*******************************

'******************************************************************************
'Name:  boExecute                                                             '
'                                                                             '
'-----------------------------------------------------------------------------'
'Purpose:      Passes a SQL statement to Falcon, to have it executed.  Then   '
'              packs the results of the SQL call into an xArrayDB object for  '
'              use by the caller.                                             '
'                                                                             '
'Usage:                                                                       '
'                                                                             '
'Parameters:                                                                   '
'                                                                             '
'Assumptions:                                                                 '
'                                                                             '
'Notes:                                                                       '
'                                                                             '
'Return Value:  True   Falcon executes SQL statement successfully             '
'               False  otherwise                                              '
'                                                                             '
'******************************************************************************
Public Function boExecute(ByVal vsSQLStatement As String, Optional ByVal vboIncludeStatusColumn As Boolean = False) As Boolean
  Dim bReturn As Boolean
    
    ' Assume success
    bReturn = True
    
    ' First get the Results array ready
    If Not IsNull(m_xaResults) Then
      Set m_xaResults = Nothing
    End If
    
    Set m_xaResults = New XArrayDB
    
    ' Reset "last error" variable
    m_strLastFalconError = ""
    
    ' Set the SQL to be executed
    m_oFalcon.SQL = vsSQLStatement
    
    ' Execute the SQL statement on the server and get any results
    m_oFalcon.Execute
    
    ' Check for an error
    If m_strLastFalconError <> "" Then
      Debug.Print "Falcon ERROR!" & vbNewLine & "Error = " & m_strLastFalconError
      bReturn = False
    Else
  
      ' Handle the results (if any) from the query
      If m_oFalcon.IsEOF Then
        Debug.Print "Falcon return no data"
      Else
        
      End If
      
      Debug.Print "Falcon Status: Returned from data fetch."
      
      ' Read from the Falcon object and
      ' place the data into the local results.
      PackResults vboIncludeStatusColumn
      
      Debug.Print "Falcon Status: Done."
    End If
    
    boExecute = bReturn
    
End Function


'******************************************************************************
'Name:  boInit                                                                '
'                                                                             '
'-----------------------------------------------------------------------------'
'Purpose:      Initialize the WSICFalconBase class                            '
'                                                                             '
'Usage:                                                                       '
'                                                                             '
'Parameters:                                                                  '
'                                                                             '
'Assumptions:                                                                 '
'                                                                             '
'Notes:                                                                       '
'                                                                             '
'Return Value:                                                                '
'                                                                             '
'******************************************************************************
Public Function boInit(ByVal vsServer As String, ByVal vsConnectionString As String, _
                       ByVal vsDBUserID As String, ByVal vsDBPassword As String) As Boolean
  
  ' Assume failure
  boInit = False
  
  On Error GoTo ErrTrap
  
  With m_oFalcon
    .RemoteServer = vsServer
    .DBConnectionString = vsConnectionString
    .DBUserId = vsDBUserID
    .DBPassword = vsDBPassword
  End With
  
  ' If we made it here then its all good
  boInit = True
  Exit Function
  
ErrTrap:
  MsgBox Err.Description, vbCritical, "CWSIFalconBase.boInit - Error"
End Function

'******************************************************************************
'Name:                                                                        '
'                                                                             '
'-----------------------------------------------------------------------------'
'Purpose:                                                                     '
'                                                                             '
'Usage:                                                                       '
'                                                                             '
'Parameters:                                                                   '
'                                                                             '
'Assumptions:                                                                 '
'                                                                             '
'Notes:                                                                       '
'                                                                             '
'Return Value:                                                                '
'                                                                             '
'******************************************************************************
Private Sub PackResults(Optional ByVal vboIncludeStatusColumn As Boolean)
    ' local variables
    Dim iRow As Integer
    Dim iColumn As Integer
    Dim iColumnCount As Integer
    Dim strResults As String
    
    Debug.Print "Fill xArray with Falcon results"
    ' Loop throught the results of the SQL statement
    ' putting the delimited values into the xArray and strResults
    If vboIncludeStatusColumn Then
      iColumnCount = m_oFalcon.FieldCount + 1
    Else
      iColumnCount = m_oFalcon.FieldCount
    End If
    
    ' Count the rows and allocate the space for the xArray.  This is faster
    ' than doing a redim for each row.
    While Not m_oFalcon.IsEOF
      iRow = iRow + 1
      m_oFalcon.MoveNext
    Wend
    m_xaResults.ReDim 1, iRow, 1, iColumnCount

    ' Return the record pointer to the first record to process the records.
    m_oFalcon.MoveFirst
    iRow = 1
    While Not m_oFalcon.IsEOF
        'We add an extra column and enter a value to indicate that all
        ' rows are in Normal status.
        For iColumn = 1 To (iColumnCount)
          If vboIncludeStatusColumn Then
            If iColumn = (iColumnCount) Then
              m_xaResults(iRow, iColumn) = Trim(g_MCF_NORMAL)
            Else
              m_xaResults(iRow, iColumn) = Trim(m_oFalcon.Field(iColumn))
              strResults = strResults & m_oFalcon.Field(iColumn) + " - "
            End If
          Else
            m_xaResults(iRow, iColumn) = Trim(m_oFalcon.Field(iColumn))
            strResults = strResults & m_oFalcon.Field(iColumn) + " - "
          End If
        Next iColumn
        
        'strResults = strResults + m_ofalcon.Field(iColumn) + " - "
        'strResults = Left(strResults, Len(strResults) - 2) + vbNewLine
        
        iRow = iRow + 1
        m_oFalcon.MoveNext
    Wend

    'Debug.Print strResults
End Sub


