Attribute VB_Name = "MainMod"
Option Explicit

Public fMain As frmMain
Public g_oApp As CEAWGlobal   ' Global App object

'******************************************************************************
'Name:        Main                                                            '
'                                                                             '
'-----------------------------------------------------------------------------'
'Purpose:    This is the Main procedure for the application                   '
'                                                                             '
'Usage:                                                                       '
'                                                                             '
'Parameters:                                                                  '
'                                                                             '
'Assumptions:                                                                 '
'                                                                             '
'Notes:                                                                       '
'                                                                             '
'Return Value:                                                                '
'                                                                             '
'******************************************************************************
Sub Main()
  Dim strServer As String
  Dim strConnectionString As String
  Dim strDBUser As String
  Dim strDBPassword As String
  'Dim strGST As String
  'Dim strPST As String
  Dim strSQL As String
  'Dim IsValidLogin As Boolean
  'Dim fLogin As New frmLogin
  'Dim xaLogin As XArrayDB
  
    On Error GoTo ErrTrap
    
    ' Create a new global App object
    Set g_oApp = New CEAWGlobal
    
    ' Get ini settings to initialize g_oApp
    strServer = GetProfile(g_REMOTE_SERVER_SECTION, g_SERVER_KEY, g_ERROR_DEFAULT, App.Path & "\" & App.EXEName & ".ini")
    strConnectionString = GetProfile(g_REMOTE_SERVER_SECTION, g_CONNECTION_KEY, g_ERROR_DEFAULT, App.Path & "\" & App.EXEName & ".ini")
    strDBUser = GetProfile(g_REMOTE_SERVER_SECTION, g_DBUSER_KEY, g_ERROR_DEFAULT, App.Path & "\" & App.EXEName & ".ini")
    strDBPassword = GetProfile(g_REMOTE_SERVER_SECTION, g_DBPASSWORD_KEY, g_ERROR_DEFAULT, App.Path & "\" & App.EXEName & ".ini")
    'strGST = GetProfile(g_TAX_SECTION, g_GST, g_ERROR_DEFAULT, App.Path & "\" & App.EXEName & ".ini")
    'strPST = GetProfile(g_TAX_SECTION, g_PST, g_ERROR_DEFAULT, App.Path & "\" & App.EXEName & ".ini")
    
    If Not g_oApp.boInit(strServer, strConnectionString, strDBUser, strDBPassword) Then GoTo ErrTrap
    
    ' Set Tax amounts
    'g_oApp.GST = CDbl(vNullZero(strGST))
    'g_oApp.PST = CDbl(vNullZero(strPST))
    
    ' Force login
    'IsValidLogin = False
    
    'Do While Not IsValidLogin
    '
    '  fLogin.Show vbModal
    '
    '  If Not fLogin.OK Then
    '    ' User pressed cancel button so exit app
    '    ' I know...I know goto's are the devil's work but heh it works here
    '    GoTo ExitMain:
    '  Else
    '    ' Do login check
    '    ' Build sql string
    '    strSQL = strBuildLoginSQL(fLogin.txtUserName.Text, fLogin.txtPassword.Text)
    '    If g_oApp.FalconBase.boExecute(strSQL) Then
    '      ' SQL executed successfully so get the result
    '      Set xaLogin = g_oApp.FalconBase.Result
    '      ' Compare the DB result
    '      ' Use g_DB_FALSE as sp_Login returns Loan Depot if successful
    '      IsValidLogin = (xaLogin(1, 1) <> g_DB_FALSE)
    '      If IsValidLogin Then
    '        ' Get the user's Loan Depot
    '        g_oApp.UserLoanDepot = xaLogin(1, 1) & ""
    '      Else
    '        MsgBox g_MSG_LOGIN_FAIL, vbExclamation, g_MSG_TITLE_LOGIN_FAIL
    '      End If
    '    Else
    '      ' Execute failed
    '      Err.Raise g_FALCON_EXECUTE_ERROR, "Login", g_oApp.FalconBase.LastError
    '    End If
    '
    '  End If
    'Loop
    
    ' Get the login form out of memory
    'Unload fLogin
    
    Set fMain = New frmMain
    fMain.Show
    
    ' Clean up Main form
    'Set fMain = Nothing
    
    Exit Sub
    
    
ExitMain:
  ' Do clean up before exiting
  'Unload fLogin
  'Set fLogin = Nothing
  Set g_oApp = Nothing
  
  Exit Sub
    
ErrTrap:
  MsgBox "Error: " & Str$(Err.Number) & " - " & Err.Description, vbCritical, Err.Source & "Error"
  
  Resume ExitMain
  
End Sub


'******************************************************************************
'Name:        strBuildLoginSQL                                                '
'                                                                             '
'-----------------------------------------------------------------------------'
'Purpose:    Builds a SQL string to call the Login Stored Procedure           '
'                                                                             '
'Usage:                                                                       '
'                                                                             '
'Parameters:                                                                  '
'                                                                             '
'Assumptions:                                                                 '
'                                                                             '
'Notes:                                                                       '
'                                                                             '
'Return Value:                                                                '
'                                                                             '
'******************************************************************************
Private Function strBuildLoginSQL(ByVal vstrUserID As String, ByVal vstrPassword As String) As String
  strBuildLoginSQL = "EXEC sp_Login " & strPrepDBString(vstrUserID) & ", " & strPrepDBString(vstrPassword)
End Function
