Attribute VB_Name = "basConstants"
' ----------------------------------------------------------------------------------
' Class Module: basConstants                                                       '
'                                                                                  '
' Purpose:      A repository of global constants                                   '
'                                                                                  '
' Usage:                                                                           '
' ----------------------------------------------------------------------------------

Option Explicit


' Ini File Access Constants
Public Const g_REMOTE_SERVER_SECTION = "Remote Server"
Public Const g_SERVER_KEY = "ServerName"
Public Const g_CONNECTION_KEY = "Connection"
Public Const g_DBUSER_KEY = "User"
Public Const g_DBPASSWORD_KEY = "Pwd"
Public Const g_TAX_SECTION = "Taxes"
'Public Const g_GST = "GST"
'Public Const g_PST = "PST"
Public Const g_ERROR_DEFAULT = "ERROR"

' Database Constants
Public Const g_DB_TRUE = "OK"
Public Const g_DB_FALSE = "FAILED"
Public Const g_DB_BOOLEAN_TRUE = "Y"
Public Const g_DB_BOOLEAN_FALSE = ""

' Format Constants
Public Const g_DATE_FORMAT = "MMM dd, yyyy"
Public Const g_MONEY_FORMAT = "#,##0.00"

' Mask Constants
Public Const g_PHONE_MASK = "(###) ###-####"
Public Const g_POSTALCODE_MASK = ">?#? #?#"
Public Const g_MONEY_MASK = "###,###.##"

' Miscellaneous Constants
Public Const g_MCF_NEW_KEY = -1
Public Const g_CASE_OFFSET = 32

' Status Column Edit Constants
Public Const g_MCF_NEW = -1
Public Const g_MCF_NORMAL = 1
Public Const g_MCF_EDIT = 2
Public Const g_MCF_DELETE = 3

' xArray Constants
Public Const g_XARRAY_ROWS = 1
Public Const g_XARRAY_COLUMNS = 2

' SQL Builder Constants
Public Const g_NEW_KEY_DECLARATION = "Declare @NewKey as Integer" & vbNewLine
Public Const g_ERROR_DECLARATION = "Declare @ReturnError as Integer" & vbNewLine
Public Const g_BEGIN_TRANSACTION = "BEGIN Transaction "
Public Const g_ROLLBACK_TRANSACTION = "IF @ReturnError <> 0 " & vbNewLine & _
                                     "  BEGIN " & vbNewLine & _
                                     "    ROLLBACK Transaction " & vbNewLine & _
                                     "    GOTO EXIT_STATEMENT" & vbNewLine & _
                                     "  END"
Public Const g_COMMIT_TRANSACTION = "IF @ReturnError = 0 " & vbNewLine & "  COMMIT Transaction " & vbNewLine & _
                                   vbNewLine & "EXIT_STATEMENT:"
Public Const g_ERROR_PARAMETER = "@Error = @ReturnError OUTPUT"
Public Const g_KEY_PARAMETER = "@Key = @NewKey OUTPUT"
Public Const g_SELECT_KEY_AND_ERROR = "SELECT NextKey = @NewKey, Error = @ReturnError"
Public Const g_SELECT_KEY = "SELECT NextKey = @NewKey"
Public Const g_SELECT_ERROR = "SELECT Error = @ReturnError"
Public Const g_KEY = "@NewKey"

' Message Title Constants
Public Const g_MSG_TITLE_LOGIN_FAIL = "Login Failed"

' Message Constants
Public Const g_MSG_LOGIN_FAIL = "Invalid Username or Password"

' Custom Error Constants
Public Const g_FALCON_INIT_ERROR = vbObjectError + 1000
Public Const g_FALCON_EXECUTE_ERROR = vbObjectError + 1010
Public Const g_NO_DATA_ERROR = vbObjectError + 1020
Public Const g_XARRAY_ROW_NOT_FOUND = vbObjectError + 1030
Public Const g_XARRAY_ROW_NOT_CREATED = vbObjectError + 1040
Public Const g_INVALID_EDIT_STATUS = vbObjectError + 1050

' Equipment Status Constants
'Public Const g_EQUIP_ON_LOAN = "LO"
'Public Const g_EQUIP_AVAILABLE = "AV"
