Attribute VB_Name = "basGeneral"
' ********************************************************************
' $Archive:: /Red Cross/MCF/Next/App/basGeneral.bas                $
' $Author:: Chuck.hatt                                             $
' $Date:: 4/09/01 8:31a                                            $
' $Modtime:: 31/08/01 11:16a                                       $
' $Revision:: 10                                                   $
'
' ********************************************************************
' $Log:: /Red Cross/MCF/Next/App/basGeneral.bas                    $
' 
' 10    4/09/01 8:31a Chuck.hatt
' Added SetCheckBoxFromBool which returns 1 (true) or 0 (false)
' depending on the bool passed in. 
'
' 9     8/10/01 2:41p Andy.zoltay
' Forgot to make vZeroToNullString a public function
'
' 8     8/10/01 2:31p Andy.zoltay
' added vZeroToNullString
'
' 7     10/08/01 1:58p Chuck.hatt
' Worked on creating edit control masking.  Not competed but left in
' the file.
'
' 6     8/03/01 4:14p Andy.zoltay
' Added strBoolToString and added some comments
'
' 5     7/30/01 9:00p Andy.zoltay
' Framework development
'
' 4     7/26/01 8:47p Andy.zoltay
' Initial development - end of day check in
'
' 3     26/07/01 9:58a Chuck.hatt
' Didn't make any changes ;-(
'
' 2     7/25/01 6:37p Andy.zoltay
' End of day check in
' ********************************************************************


' ----------------------------------------------------------------------------------
' Class Module: CMCFGlobal                                                         '
'                                                                                  '
' Purpose:      A global class to pass around info required by entire application  '
'                                                                                  '
' Usage:                                                                           '
' ----------------------------------------------------------------------------------

Option Explicit
'========================== API Declarations ========================
' WIN API Function Declarations
Private Declare Function GetPrivateProfileString Lib "KERNEL32" Alias "GetPrivateProfileStringA" (ByVal lpApplicationName As String, ByVal lpKeyName As Any, ByVal lpDefault As String, ByVal lpReturnedString As String, ByVal nSize As Long, ByVal lpFileName As String) As Long
Private Declare Function WritePrivateProfileString Lib "KERNEL32" Alias "WritePrivateProfileStringA" (ByVal lpApplicationName As String, ByVal lpKeyName As Any, ByVal lpString As Any, ByVal lpFileName As String) As Long
Private Declare Function GetLocaleInfo Lib "KERNEL32" Alias "GetLocaleInfoA" (ByVal Locale As Long, ByVal LCType As Long, ByVal lpLCData As String, ByVal cchData As Long) As Long
Private Declare Sub CopyMemory Lib "KERNEL32" Alias "RtlMoveMemory" (Destination As Any, Source As Any, ByVal Length As Long)

'=========================== Enumerations ===========================
Public Enum eMCFEditModes
  emcfNone
  emcfAdd
  emcfEdit
  emcfDelete
  emcfError
End Enum

Public Enum eMCFExitModes
  emcfOK
  emcfCancel
  emcfRetry
End Enum

Public Sub SetProfile(ByVal strSection As String, ByVal strKeyword As String, ByVal strValue As String, ByVal strINIFileName As String)
  Dim szValue As String
 
  szValue = strValue
  Call WritePrivateProfileString(strSection, strKeyword, szValue, strINIFileName)
End Sub
 
Public Function GetProfile(ByVal strSection As String, ByVal strKeyword As String, ByVal strDefault As String, ByVal strINIFileName As String) As String
  Dim strResult As String
  Dim loResult As Long
 
  strResult = String(80, Chr(0))
  loResult = GetPrivateProfileString(strSection, strKeyword, strDefault, strResult, 80, strINIFileName)
  If loResult = 0 Then
    GetProfile = vbNullString
  Else
    GetProfile = Left(strResult, loResult)
  End If
End Function
'
'Public Function GetSystemShortDateFormat() As String
'  Dim lLocalID As Long
'
'    lLocalID = GetUserDefaultLCID
'
'    GetSystemShortDateFormat = GetUserLocaleInfo(lLocalID, LOCALE_SSHORTDATE)
'
'End Function


'******************************************************************************
'Name:     strPrepDBString                                                    '
'                                                                             '
'-----------------------------------------------------------------------------'
'Purpose:  Prepares a string value for database insertion                     '
'          Encapsulates the string in single quotes                           '
'          Replace all occurances of ' with ''                                '
'Usage:                                                                       '
'                                                                             '
'Parameters:                                                                  '
'                                                                             '
'Assumptions:                                                                 '
'                                                                             '
'Notes:                                                                       '
'                                                                             '
'Return Value:                                                                '
'                                                                             '
'******************************************************************************
Public Function strPrepDBString(ByVal vstrSource As String) As String
  Dim strDestination As String
    
    ' Loop through the Source string and replace all occurances of ' with ''
    strDestination = Replace(vstrSource, "'", "''")
    
    strPrepDBString = "'" & strDestination & "'"
End Function

'******************************************************************************
'Name:       vNullZero                                                        '
'                                                                             '
'-----------------------------------------------------------------------------'
'Purpose:    Converts vIn to zero if it is null or an empty string            '
'Usage:                                                                       '
'                                                                             '
'Parameters:                                                                  '
'                                                                             '
'Assumptions:                                                                 '
'                                                                             '
'Notes:                                                                       '
'                                                                             '
'Return Value:                                                                '
'                                                                             '
'******************************************************************************
Public Function vNullZero(ByVal vIn As Variant) As Variant
  If IsNull(vIn) Then
    vNullZero = 0
  Else
    If CStr(vIn) = "" Then
      vNullZero = 0
    Else
      vNullZero = vIn
    End If
  End If
End Function

'******************************************************************************
'Name:       vZeroToNullString                                                '
'                                                                             '
'-----------------------------------------------------------------------------'
'Purpose:    Returns a string with a Null value if vvarData is O or ""        '
'Usage:                                                                       '
'                                                                             '
'Parameters:                                                                  '
'                                                                             '
'Assumptions:                                                                 '
'                                                                             '
'Notes:                                                                       '
'                                                                             '
'Return Value:                                                                '
'                                                                             '
'******************************************************************************
Public Function vZeroToNullString(ByVal vvarData As Variant) As String
  If (vvarData = 0) Or (Len(CStr(vvarData)) = 0) Then
    vZeroToNullString = "Null"
  Else
    vZeroToNullString = CStr(vvarData)
  End If
End Function

'******************************************************************************
'Name:     strBoolToString                                                    '
'                                                                             '
'-----------------------------------------------------------------------------'
'Purpose:  Converts a Boolean to a string representation of the boolean       '
'                                                                             '
'Usage:                                                                       '
'                                                                             '
'Parameters:                                                                  '
'                                                                             '
'Assumptions:                                                                 '
'                                                                             '
'Notes:                                                                       '
'                                                                             '
'Return Value:  boSource = True then return "Y"                               '
'               boSource = False then return ""                               '
'                                                                             '
'******************************************************************************
Public Function strBoolToString(ByVal boSource As Boolean) As String
  If boSource Then
    strBoolToString = g_DB_BOOLEAN_TRUE
  Else
    strBoolToString = ""
  End If
End Function


'******************************************************************************
'Name:     SetMaskedEdit                                                      '
'                                                                             '
'-----------------------------------------------------------------------------'
'Purpose:  Apply a mask to data entered into a simple TextBox.                '
'                                                                             '
'Usage:                                                                       '
'                                                                             '
'Parameters:    roEdit      A reference to the TextBox the data is to be      '
'                           displayed in.                                     '
'               vstrData    The data to be displayed.                         '
'               vstrMask    The mask to apply to the data.                    '
'               vstrMasdChar  The charater used to create the mask            '
'                             ie "#####.##"                                   '
'               vboFromRight  If True process data from the right side of the '
'                             input string else process from the left         '
'                                                                             '
'Assumptions:   The mask is as long or longer than the data                   '
'                                                                             '
'Notes:                                                                       '
'                                                                             '
'Return Value:                                                                '
'                                                                             '
'******************************************************************************
Public Function SetMaskedEdit(ByRef roEdit As TextBox, _
                              ByVal vstrData As String, _
                              ByVal vstrMask As String, _
                              Optional ByVal vboFromRight As Boolean = True)
  Dim strMaskChar As String
  Dim loMaskLen As Long
  Dim loMaskCount As Long
  
  Dim loDataCount As Long
  Dim loDataLen As Long
  Dim strDataChar As String
  
  Dim strOutput As String
  Dim boValidChar As Boolean
  
  loDataLen = Len(vstrData)
  loMaskLen = Len(vstrMask)
    
  Debug.Print vstrData
  
  ' Loop through the mask and populate the output string based
  ' on the mask characters.
  While (loMaskLen - loMaskCount) > 0
    'assume then next char is valid and set to false when you validate the char.
    boValidChar = True
    
    ' Fill the TextBox from the Right to the left.
    If vboFromRight Then
      ' Get the next character from the mask.
      strMaskChar = Mid(vstrMask, loMaskLen - loMaskCount, 1)
      
      ' We have a mask char replace it in the output string with a data
      ' character and increment our data counter.
      If (strMaskChar = "#") Or (strMaskChar = "?") Then
        ' Check to see if we have processed all of the data if so replace
        ' all Mask chars with a blank.
        If loDataLen > loDataCount Then
          strDataChar = Mid(vstrData, loDataLen - loDataCount, 1)
          boValidChar = ValidateDataChar(strDataChar, strMaskChar)
        Else
          strDataChar = " "
        End If
        
        If boValidChar Then
          strOutput = strDataChar & strOutput
          loDataCount = loDataCount + 1
        End If
      Else
        ' Add the literal from the mask.
        strOutput = strMaskChar & strOutput
      End If
      Debug.Print strOutput
      
    Else  ' Fill the textbox from the right to the left.
      ' Get the next character from the mask.
      strMaskChar = Mid(vstrMask, loMaskCount + 1, 1)
      
      ' We have a mask char replace it in the output string with
      ' and increment our data counter.
      If (strMaskChar = "#") Or (strMaskChar = "?") Then
        strOutput = strOutput & Mid(vstrData, loDataCount + 1, 1)
        loDataCount = loDataCount + 1
      Else
        ' Add the literal from the mask.
        strOutput = strOutput & strMaskChar
      End If
      Debug.Print strOutput
    End If
    
    ' Always increment the mask counter.
    loMaskCount = loMaskCount + 1
  Wend
    
  ' Set the Text property of the passed TextBox.
  roEdit.Text = strOutput
End Function


'******************************************************************************
'Name:     GetMaskedEdit                                                      '
'                                                                             '
'-----------------------------------------------------------------------------'
'Purpose:  Apply a mask to data being returned from a simple TextBox.         '
'                                                                             '
'Usage:                                                                       '
'                                                                             '
'Parameters:    roEdit      A reference to the TextBox the data is to be      '
'                           displayed in.                                     '
'               vstrData    The data to be displayed.                         '
'               vstrMask    The mask to apply to the data.                    '
'               vstrMasdChar  The charater used to create the mask            '
'                             ie "#####.##"                                   '
'               vboFromRight  If True process data from the right side of the '
'                             input string else process from the left         '
'                                                                             '
'Assumptions:   The mask is as long or longer than the data                   '
'                                                                             '
'Notes:                                                                       '
'                                                                             '
'Return Value:                                                                '
'                                                                             '
'******************************************************************************
Public Function GetMaskedEdit(ByRef roEdit As TextBox, _
                              ByVal vstrMask As String) As String
  
  Dim strMaskChar As String
  Dim loMaskLen As Long
  Dim loMaskCount As Long
  
  Dim loDataCount As Long
  Dim loDataLen As Long
  Dim strDataChar As String
  
  Dim strData As String
  Dim strOutput As String
                            
  strData = roEdit.Text
  loMaskLen = Len(vstrMask)
  loDataLen = Len(strData)
  
  While (loMaskLen - loMaskCount) > 0
    strMaskChar = Mid(vstrMask, loMaskLen - loMaskCount, 1)
    
    If strMaskChar = "?" Or strMaskChar = "#" Then
      strDataChar = Mid(strData, loDataLen - loDataCount, 1)
      loDataCount = loDataCount + 1
      strOutput = strDataChar & strOutput
    Else
      'this character was a literal added by the mask
      loDataCount = loDataCount + 1
    End If
    loMaskCount = loMaskCount + 1
    Debug.Print strOutput
  Wend
  GetMaskedEdit = strOutput
End Function



'******************************************************************************
'Name:     ValidateDataChar                                                   '
'                                                                             '
'-----------------------------------------------------------------------------'
'Purpose:  Ensure that the data character matches the mask type.              '
'                                                                             '
'Usage:                                                                       '
'                                                                             '
'Parameters:    vstrChar    The data character to be validatated              '
'               vstrMask    The mask character to validate against.           '
'                                                                             '
'Assumptions:   The mask character is either a ? or a #                       '
'               The var vstrChar contains a single character.                 '                                                                             '
'Notes:         ? is an alpha character and # is a numeric character.         '
'                                                                             '
'Return Value:  If vstrChar's contenets data type matches the data type of    '
'               vstrMask return True otherwiser return False                  '
'                                                                             '
'******************************************************************************
Private Function ValidateDataChar(ByVal vstrChar As String, _
                                  ByVal vstrMask As String) As Boolean
  
  If vstrMask = "#" Then
    ValidateDataChar = IsNumeric(vstrChar)
  Else
    ValidateDataChar = Not IsNumeric(vstrChar)
  End If
End Function

'******************************************************************************
'Name:     SetCheckBoxFromBool                                                '
'                                                                             '
'-----------------------------------------------------------------------------'
'Purpose:  To convert a boolean value to and integer.                         '
'                                                                             '
'Usage:                                                                       '
'                                                                             '
'Parameters:    vboInVal    A The boolean to be converted.                    '
'                                                                             '
'Assumptions:   N/A                                                           '                                                                             '
'Notes:                                                                       '
'                                                                             '
'Return Value:  True input returns a 1 and false input returns 0              '
'                                                                             '
'******************************************************************************
Public Function SetCheckBoxFromBool(ByVal vboInVal As Boolean) As Integer
  If vboInVal Then
    SetCheckBoxFromBool = 1
  Else
    SetCheckBoxFromBool = 0
  End If
End Function



