VERSION 1.0 CLASS
BEGIN
  MultiUse = -1  'True
  Persistable = 0  'NotPersistable
  DataBindingBehavior = 0  'vbNone
  DataSourceBehavior  = 0  'vbNone
  MTSTransactionMode  = 0  'NotAnMTSObject
END
Attribute VB_Name = "clsParseEngine"
Attribute VB_GlobalNameSpace = False
Attribute VB_Creatable = True
Attribute VB_PredeclaredId = False
Attribute VB_Exposed = False
Option Explicit
'Option Compare Binary 'Force case sensitive string comparisons for correct key values in collections.

Private m_boInitialized As Boolean
Private m_lngNumberOfLines As Long
Private m_prgProgBar As ccrpProgressBar
Private m_intFileNumber As Integer
Private m_colErrors As Collection
Private m_colEmailPlayers As Collection
Private m_colNumericIDPlayers As Collection
Private m_colNamePlayers As Collection
Private m_colCompletePlayers As Collection
Private m_clsServer As clsServer
Private m_clsSummary As clsSummary

'Holds temp connection info in case of multithreading collisions.
Private m_colTempLoginMatchup As Collection

Private Enum m_enPlayerIDType
  enEmail = 0
  enNumericID
  enName
  enEmailAndID
End Enum

Const m_ERROR = "Error!:"
Const m_WARNING = "Warning:"
Const m_INFO = "Info:"
Dim m_INFO_LEN As Integer
Const m_INFO_CM = "Info: CM ("
Dim m_INFO_CM_LEN As Integer
Const m_INFO_MM = "Info: MM ("
Dim m_INFO_MM_LEN As Integer
Const m_INFO_FFC = "Info: FFC ("
Dim m_INFO_FFC_LEN As Integer
Const m_INFO_MC = "Info: MC ("
Dim m_INFO_MC_LEN As Integer
Const m_SERVER_START = "Info: ServerManager started"
Const m_LOAD_SAVED_PLAYER = "CharacterLogOnRelayNameC is temporarily under T0:"
Const m_CLIENT_QUERIES = "Info: Client querying server."
Const m_STARTING_BATTLE = "): Starting battle at hex("
Const m_TURN = "Info: Turn "
Dim m_TURN_LEN As Integer
Dim m_strCurrentTurn As String

Const m_LOGON_1_OF_14 = "CharacterLogOnRelayNameC published under SwitchID:"
Const m_LOGON_2_OF_14 = "PlayerRelayC published under SwitchID:"
Const m_LOGON_3_OF_14 = "MessengerRelayNameC published under SwitchID:"
Const m_LOGON_4_OF_14 = "MetaClientHelpListPanel published under SwitchID:"
Const m_LOGON_5_OF_14 = "MissionRelayNameC published under SwitchID:"
Const m_LOGON_6_OF_14 = "MetaClientMissionPanel published under SwitchID:"
Const m_LOGON_7_OF_14 = "MetaClientShipPanel published under SwitchID:"
Const m_LOGON_8_OF_14 = "MetaClientSupplyDockPanel published under SwitchID:"
Const m_LOGON_9_OF_14 = "MedalsPanel published under SwitchID:"
Const m_LOGON_10_OF_14 = "MetaClientNewsPanel published under SwitchID:"
Const m_LOGON_11_OF_14 = "MetaClientPlayerListPanel published under SwitchID:"
Const m_LOGON_12_OF_14 = "PlayerInfoPanel published under SwitchID:"
Const m_LOGON_13_OF_14 = "MetaViewPortHandlerNameC published under SwitchID:"
Const m_LOGON_14_OF_14 = "MetaClientChatPanel published under SwitchID:"

Const m_LOGOUT_1_OF_13 = "CharacterLogOnRelayNameC closed"
Const m_LOGOUT_2_OF_13 = "MedalsPanel closed"
Const m_LOGOUT_3_OF_13 = "MessengerRelayNameC closed"
Const m_LOGOUT_4_OF_13 = "MetaClientHelpListPanel closed"
Const m_LOGOUT_5_OF_13 = "MetaClientMissionPanel closed"
Const m_LOGOUT_6_OF_13 = "MetaClientNewsPanel closed"
Const m_LOGOUT_7_OF_13 = "MetaClientPlayerListPanel closed"
Const m_LOGOUT_8_OF_13 = "MetaClientShipPanel closed"
Const m_LOGOUT_9_OF_13 = "MetaClientSupplyDockPanel closed"
Const m_LOGOUT_10_OF_13 = "MetaViewPortHandlerNameC closed"
Const m_LOGOUT_11_OF_13 = "MissionRelayNameC closed"
Const m_LOGOUT_12_OF_13 = "PlayerInfoPanel closed"
Const m_LOGOUT_13_OF_13 = "PlayerRelayC closed"

Const m_MM_RECEIVED_PLAYER_INFO = "): Received player info from db"
Const m_MM_MISSION = "): ->"
Const m_MM_FINISHED = "): Finished MM"
Const m_MM_NONE_CHOSEN = "): Has chosen no mission"
Const m_MM_NEARBY_HUMAN = "): -> Found nearby Human ("
Const m_MM_NO_MISSIONS = "): -> none determined"
Const m_CM_START_DRAFT = "): -> Sending to human"
Const m_CM_GET_IP = "): Client match host at IP: ("
Const m_CM_MISSION_TEAM = "): === ID: ("
Const m_CM_ACCEPTED_DRAFT = "): Received play response from human"
Const m_CM_START_BATTLE = "): Starting battle at hex("
Const m_MC_MISSION_COMPLETE = ") hosted battle at hex("
Const m_CM_FORFEIT_DRAFT = "chose to forfeit the challenge"
Const m_CM_STARTING_AI_MISSION = "): No other humans, so will skip sending mission lists"

Const m_SERVER_PROCESS = "*~Server~* .?"

Const m_CONNECT_1_OF_5 = "Info: Connection accepted ("
Const m_CONNECT_2_OF_5 = "Info: Authenticating Connection ("
Const m_CONNECT_3_OF_5 = "Info: Connection authenticated ("
Const m_CONNECT_4_OF_5 = "Info: Connection assigned to switch ID:"
Const m_CONNECT_5_OF_5 = m_LOGON_1_OF_14

Public Property Get Summary() As clsSummary
  Set Summary = m_clsSummary
End Property
Public Property Get Players() As Collection
  Set Players = m_colCompletePlayers
End Property
Public Property Get IncompletePlayers() As Collection
  Set IncompletePlayers = m_colEmailPlayers
End Property

Public Sub Init(ByVal FileNumber As Integer, _
  ByRef ProgBar As ccrpProgressBar, _
  ByVal NumberOfLines As Long)
  
  Set m_prgProgBar = ProgBar
  m_lngNumberOfLines = NumberOfLines
  m_intFileNumber = FileNumber
  
  Set m_clsServer = New clsServer
  Set m_colErrors = New Collection
  Set m_colEmailPlayers = New Collection
  Set m_clsSummary = New clsSummary
  Set m_colNumericIDPlayers = New Collection
  Set m_colNamePlayers = New Collection
  Set m_colCompletePlayers = New Collection
  Set m_colTempLoginMatchup = New Collection
  
  m_prgProgBar.Max = m_lngNumberOfLines
  m_prgProgBar.IncrementSize = m_prgProgBar.Max / 100
  
  m_boInitialized = True
  
  'Initialize lengths for constants.

  m_INFO_LEN = Len(m_INFO)
  m_INFO_CM_LEN = Len(m_INFO_CM)
  m_INFO_MM_LEN = Len(m_INFO_MM)
  m_INFO_FFC_LEN = Len(m_INFO_FFC)
  m_INFO_MC_LEN = Len(m_INFO_MC)
  m_TURN_LEN = Len(m_TURN)

End Sub

Public Function FullParse() As Boolean
  'Parse the entire file.
  'Errors are added to the collection
  'Players are added to their collection
  'Server info is added to the server object
  
  If Not m_boInitialized Then
    MsgBox "Error: clsParseEngine.FullParse - Class not initialized.", vbCritical
  End If
  
  Dim tmpPlayer As clsPlayer
  Dim tmpError As clsError
  Dim strLine As String
  Dim lngLineCnt As Long
  Dim strTemp As String
  Dim intTemp As Integer
  Dim lngCnt As Long
  Dim strPlayerID As String
  Dim intConnectStep As Integer
  
  'crap...
  Dim crap As Integer
  
  'Being parsing loop.
  Do While Not EOF(m_intFileNumber)
    strLine = GetLine
    
    'If no length then increment blank line count in summar object
    If Len(strLine) = 0 Then
      m_clsSummary.IncrementBlankLines
    '*********  Error
    ElseIf Mid(strLine, 1, Len(m_ERROR)) = m_ERROR Then
      m_clsSummary.IncrementErrors
    '********* Warning
    ElseIf Mid(strLine, 1, Len(m_WARNING)) = m_WARNING Then
      m_clsSummary.IncrementWarnings
    '********* server start
    ElseIf Mid(strLine, 1, Len(m_SERVER_START)) = m_SERVER_START Then
      m_clsSummary.IncrementServerStarts
    '********* Mission Matching section
    ElseIf Mid(strLine, 1, m_INFO_MM_LEN) = m_INFO_MM Then
      strPlayerID = ExtractPlayerID(strLine)
      '+++++++ Contains player name and indicates a move
      If InStr(1, strLine, m_MM_RECEIVED_PLAYER_INFO) Then
        CompletePlayerObject strLine, m_MM_RECEIVED_PLAYER_INFO
      End If
      HandleMM (strLine)
    '********* Character Moving section
    ElseIf Mid(strLine, 1, m_INFO_CM_LEN) = m_INFO_CM Then
      
      '+++++++ Forfeited draft challenge
      If InStr(1, strLine, m_CM_FORFEIT_DRAFT) Then
        ForfeitDraft strLine, m_CM_FORFEIT_DRAFT
        
      '+++++++ Initiated mission
      ElseIf InStr(1, strLine, m_CM_START_BATTLE) Then
        InitiatedMission strLine
        
      '*********** Starting AI only mission
      ElseIf InStr(1, strLine, m_CM_STARTING_AI_MISSION) Then
        ProcessAIOnlyMission (strLine)
        
      '*********** Drafting a human
      ElseIf InStr(1, strLine, m_CM_START_DRAFT) Then
        DraftingHumans (strLine)
      
      '+++++++++++ Accepted Draft
      ElseIf InStr(1, strLine, m_CM_ACCEPTED_DRAFT) Then
        AcceptedDraft (strLine)
      
      End If
      
      
      'HandleCM (strLine)
      
    '********* Forfeit section?
    ElseIf Mid(strLine, 1, m_INFO_FFC_LEN) = m_INFO_FFC Then
      HandleFCC (strLine)
    '********* Mission Complete section
    ElseIf Mid(strLine, 1, m_INFO_MC_LEN) = m_INFO_MC Then
      
      '++++++++++++ Mission complete line with player and team ID
      If InStr(1, strLine, m_MC_MISSION_COMPLETE) Then
        MissionComplete (strLine)
      End If
      
    '********* Connecting
    ElseIf CheckForConnectStep(strLine, intConnectStep) Then
      HandleConnectStep strLine, intConnectStep
      
    '********* Turn passed
    ElseIf Mid(strLine, 1, m_TURN_LEN) = m_TURN Then
      UpdateCurrentTurn strLine
      
    '********* Client Queries.
    ElseIf strLine = m_CLIENT_QUERIES Then
      m_clsSummary.IncrementClientQueries
    
    '********* All other lines that start with "Info: "
    ElseIf Mid(strLine, 1, m_INFO_LEN) = m_INFO Then
      
      '********* Player Account load from Database
      If InStr(1, strLine, m_LOAD_SAVED_PLAYER) Then
      '  strTemp = ExtractPlayerEmail(strline)
        'Try to add the player
        'TryAddNewPlayer strTemp, enEmail
        

      
      '********* Starting battle
      ElseIf InStr(1, strLine, m_STARTING_BATTLE) Then
        'battles started
        crap = crap + 1
      ElseIf InStr(1, strLine, m_SERVER_PROCESS) Then
        

      
      Else
        Static intStep As Integer
        
        intStep = 0
        strTemp = ""
        
        '********* Player logon
        'First check if the line qualifies as a logon line, if so we get the step
        ' number back and the player email.
        strTemp = CheckPlayerLogon(intStep, strLine)
        If intStep > 0 Then
          'ProcessPlayerLogonStep intStep, strTemp
        Else
         
          intStep = 0
          strTemp = ""
        
          '********* Player logout
          'First check if the line qualifies as a logon line, if so we get the step
          ' number back and the player email.
          'strTemp = CheckPlayerLogout(intStep, strLine)
          'If strTemp <> "-1" Then
          '  ProcessPlayerLogoutStep intStep, strTemp
          'End If
        End If
      End If
    
    End If
    
    
    If lngLineCnt Mod m_prgProgBar.IncrementSize = 0 Then
      m_prgProgBar.Increment
    End If
    lngLineCnt = lngLineCnt + 1
  Loop
  
  MsgBox "crap: " & crap

End Function

Private Function GetLine() As String
  Static strLine As String
  Line Input #m_intFileNumber, strLine
  GetLine = Trim(strLine)
End Function

Private Function CheckPlayerLogon(ByRef LogonStepFound, LogLine As String) As String
  '14 possible lines for a match.  Check for each
  Dim intPos As Integer
  Dim strEmail As String
  
  If InStr(m_INFO_LEN, LogLine, m_LOGON_1_OF_14) Then
    intPos = InStr(m_INFO_LEN, LogLine, m_LOGON_1_OF_14)
    strEmail = Trim(Mid(LogLine, m_INFO_LEN + 1, intPos - m_INFO_LEN - 1))
    LogonStepFound = 1
  ElseIf InStr(m_INFO_LEN, LogLine, m_LOGON_2_OF_14) Then
    intPos = InStr(m_INFO_LEN, LogLine, m_LOGON_2_OF_14)
    strEmail = Trim(Mid(LogLine, m_INFO_LEN + 1, intPos - m_INFO_LEN - 1))
    LogonStepFound = 2
  ElseIf InStr(m_INFO_LEN, LogLine, m_LOGON_3_OF_14) Then
    intPos = InStr(m_INFO_LEN, LogLine, m_LOGON_3_OF_14)
    strEmail = Trim(Mid(LogLine, m_INFO_LEN + 1, intPos - m_INFO_LEN - 1))
    LogonStepFound = 3
  ElseIf InStr(m_INFO_LEN, LogLine, m_LOGON_4_OF_14) Then
    intPos = InStr(m_INFO_LEN, LogLine, m_LOGON_4_OF_14)
    strEmail = Trim(Mid(LogLine, m_INFO_LEN + 1, intPos - m_INFO_LEN - 1))
    LogonStepFound = 4
  ElseIf InStr(m_INFO_LEN, LogLine, m_LOGON_5_OF_14) Then
    intPos = InStr(m_INFO_LEN, LogLine, m_LOGON_5_OF_14)
    strEmail = Trim(Mid(LogLine, m_INFO_LEN + 1, intPos - m_INFO_LEN - 1))
    LogonStepFound = 5
  ElseIf InStr(m_INFO_LEN, LogLine, m_LOGON_6_OF_14) Then
    intPos = InStr(m_INFO_LEN, LogLine, m_LOGON_6_OF_14)
    strEmail = Trim(Mid(LogLine, m_INFO_LEN + 1, intPos - m_INFO_LEN - 1))
    LogonStepFound = 6
  ElseIf InStr(m_INFO_LEN, LogLine, m_LOGON_7_OF_14) Then
    intPos = InStr(m_INFO_LEN, LogLine, m_LOGON_7_OF_14)
    strEmail = Trim(Mid(LogLine, m_INFO_LEN + 1, intPos - m_INFO_LEN - 1))
    LogonStepFound = 7
  ElseIf InStr(m_INFO_LEN, LogLine, m_LOGON_8_OF_14) Then
    intPos = InStr(m_INFO_LEN, LogLine, m_LOGON_8_OF_14)
    strEmail = Trim(Mid(LogLine, m_INFO_LEN + 1, intPos - m_INFO_LEN - 1))
    LogonStepFound = 8
  ElseIf InStr(m_INFO_LEN, LogLine, m_LOGON_9_OF_14) Then
    intPos = InStr(m_INFO_LEN, LogLine, m_LOGON_9_OF_14)
    strEmail = Trim(Mid(LogLine, m_INFO_LEN + 1, intPos - m_INFO_LEN - 1))
    LogonStepFound = 9
  ElseIf InStr(m_INFO_LEN, LogLine, m_LOGON_10_OF_14) Then
    intPos = InStr(m_INFO_LEN, LogLine, m_LOGON_10_OF_14)
    strEmail = Trim(Mid(LogLine, m_INFO_LEN + 1, intPos - m_INFO_LEN - 1))
    LogonStepFound = 10
  ElseIf InStr(m_INFO_LEN, LogLine, m_LOGON_11_OF_14) Then
    intPos = InStr(m_INFO_LEN, LogLine, m_LOGON_11_OF_14)
    strEmail = Trim(Mid(LogLine, m_INFO_LEN + 1, intPos - m_INFO_LEN - 1))
    LogonStepFound = 11
  ElseIf InStr(m_INFO_LEN, LogLine, m_LOGON_12_OF_14) Then
    intPos = InStr(m_INFO_LEN, LogLine, m_LOGON_12_OF_14)
    strEmail = Trim(Mid(LogLine, m_INFO_LEN + 1, intPos - m_INFO_LEN - 1))
    LogonStepFound = 12
  ElseIf InStr(m_INFO_LEN, LogLine, m_LOGON_13_OF_14) Then
    intPos = InStr(m_INFO_LEN, LogLine, m_LOGON_13_OF_14)
    strEmail = Trim(Mid(LogLine, m_INFO_LEN + 1, intPos - m_INFO_LEN - 1))
    LogonStepFound = 13
  ElseIf InStr(m_INFO_LEN, LogLine, m_LOGON_14_OF_14) Then
    intPos = InStr(m_INFO_LEN, LogLine, m_LOGON_14_OF_14)
    strEmail = Trim(Mid(LogLine, m_INFO_LEN + 1, intPos - m_INFO_LEN - 1))
    LogonStepFound = 14
  Else
    'did not qualify for a match...
    strEmail = "-1"
  End If

  CheckPlayerLogon = strEmail
End Function

Public Function ProcessPlayerLogonStep(LogonStep, Email) As Boolean
  Dim objPlayer As clsPlayer
  
  'First see if this player already exists or not
  'Set objPlayer = TryAddNewPlayer(Email, enEmail)
  On Error Resume Next
  Set objPlayer = m_colEmailPlayers.Item(Email)
  
  'If we didn't find them we need to add them before processing logon step from the log file.
  If objPlayer Is Nothing Then
    Stop
  Else
    objPlayer.SetLogonStep = LogonStep
  End If
  
End Function
Public Function ProcessPlayerLogoutStep(LogoutStep, Email) As Boolean
  Dim objPlayer As clsPlayer
  Set objPlayer = Nothing
  Dim boProcessed As Boolean
  
  'First see if player is in the complete collection and actively logged in
  ' or actively logging out.
  For Each objPlayer In m_colCompletePlayers
    If objPlayer.Email = Email And objPlayer.LoggedIn Then
      objPlayer.SetLogoutStep = LogoutStep
      boProcessed = True
      Exit For
    End If
  Next objPlayer
  
  'If we didn't find them check the email collection
  'They will be here if they logged in and logged out before moving.
  If Not boProcessed Then
    For Each objPlayer In m_colEmailPlayers
      If objPlayer.Email = Email Then
        objPlayer.SetLogoutStep = LogoutStep
        Exit For
      End If
    Next objPlayer
  End If
  
 
End Function

Private Function ExtractPlayerID(CurrentLine As String) As String
  Dim strTemp As String
  Dim intFirstPos As Integer
  Dim intSecPos As Integer
  Dim strMarker1 As String
  Dim strMarker2 As String
  strMarker1 = "("
  strMarker2 = ")"
  
  'We need to get the player id from the string.
  'example: Info: CM (32562): Start: Getting matching PreparedMissions package
  'We only want to return the numeric ID.
  
  'Find position of opening marker "("
  intFirstPos = InStr(1, CurrentLine, strMarker1)
  
  'Find position of closing marker ")"
  intSecPos = InStr(intFirstPos, CurrentLine, strMarker2)
  
  'Now extract the id...
  strTemp = Mid(CurrentLine, intFirstPos + 1, intSecPos - intFirstPos - 1)
  
  'Now see if we have both a name and ID, if so just take the ID
  intFirstPos = 0
  intFirstPos = InStr(1, strTemp, ":")
  
  If intFirstPos > 0 Then
    strTemp = Mid(strTemp, 1, intFirstPos - 1)
  End If
  
  If Not IsNumeric(strTemp) Then strTemp = ""
  
  ExtractPlayerID = strTemp
End Function

Private Function ExtractDraftedID(CurrentLine As String) As String
  Dim strTemp As String
  Dim intFirstPos As Integer
  Dim intSecPos As Integer
  Dim strMarker1 As String
  Dim strMarker2 As String
  strMarker1 = m_CM_START_DRAFT
  strMarker2 = "mission"
  
  'We need to get the player id from the string.
  'example: Info: CM (1771:SPQR Renegade): -> Sending to human 1908 mission Shipyard Defense
  'We only want to return the numeric ID of the player being drafted, not the drafter.
  
  'Find the start of the word "mission" after the Key line "-> Sending to human" which
  ' will indicate the position to.
  intFirstPos = InStr(1, CurrentLine, strMarker1)
  
  'Now add the length of the marker to put us at the end of that marker in the string
  intFirstPos = intFirstPos + Len(strMarker1)
  
  'Find position of closing marker "missions"
  intSecPos = InStr(intFirstPos, CurrentLine, strMarker2)
  
  'Now extract the id...
  strTemp = Trim(Mid(CurrentLine, intFirstPos + 1, intSecPos - intFirstPos - 1))
  
  'Minor validation
  If Not IsNumeric(strTemp) Then strTemp = ""
  
  ExtractDraftedID = strTemp
End Function
Private Function ExtractDraftAcceptedID(CurrentLine As String) As String
  Dim strTemp As String
  Dim intFirstPos As Integer
  Dim intSecPos As Integer
  Dim strMarker1 As String
  Dim strMarker2 As String
  strMarker1 = m_CM_ACCEPTED_DRAFT
  
  
  'We need to get the player id from the string.
  'example: Info: CM (1771:SPQR Renegade): Received play response from human 1771
  'We only want to return the numeric ID of the player responding to the draft.
  
  'Find the start of the word "mission" after the Key line "-> Sending to human" which
  ' will indicate the position to.
  intFirstPos = InStr(1, CurrentLine, strMarker1)
  
  'Now add the length of the marker to put us at the end of that marker in the string
  intFirstPos = intFirstPos + Len(strMarker1)
  
  'Now extract the id...
  strTemp = Trim(Mid(CurrentLine, intFirstPos + 1, Len(CurrentLine) - intFirstPos))
  
  'Minor validation
  If Not IsNumeric(strTemp) Then strTemp = ""
  
  ExtractDraftAcceptedID = strTemp
End Function
Private Function ExtractTeamID(CurrentLine As String) As String
  Dim strTemp As String
  Dim intFirstPos As Integer
  Dim intSecPos As Integer
  Dim intThirdPos As Integer
  Dim strMarker1 As String
  Dim strMarker2 As String
  strMarker1 = m_MC_MISSION_COMPLETE
  strMarker2 = "Team Slot:"
  
  'We need to get the player id from the string.
  'example: Info: MC (1803:Kayn) hosted battle at hex(13,18) Team Slot: 0 ID: 1803
  'We only want to return the numeric ID of the team that finished the mission.
  
  intFirstPos = InStr(1, CurrentLine, strMarker1)
  intSecPos = InStr(intFirstPos, CurrentLine, strMarker2)
  
  'Now add the length of the marker to put us at the end of that marker in the string
  intThirdPos = intSecPos + Len(strMarker2) + Len(" X ID:")
  
  'Now extract the id...
  strTemp = Trim(Mid(CurrentLine, intThirdPos + 1, Len(CurrentLine) - intThirdPos))
  
  'Minor validation
  If Not IsNumeric(strTemp) Then strTemp = ""
  
  ExtractTeamID = strTemp
End Function

Private Function ExtractPlayerEmail(CurrentLine As String) As String
  Dim strTemp As String
  Dim intTemp As Integer
  
  'Extract player email from line.
  If InStr(1, CurrentLine, m_LOAD_SAVED_PLAYER) Then
    intTemp = InStr(1, CurrentLine, m_LOAD_SAVED_PLAYER)
    strTemp = Trim(Mid(CurrentLine, m_INFO_LEN + 1, intTemp - m_INFO_LEN - 1))
  ElseIf InStr(1, CurrentLine, m_CONNECT_5_OF_5) Then
    intTemp = InStr(1, CurrentLine, m_CONNECT_5_OF_5)
    strTemp = Trim(Mid(CurrentLine, m_INFO_LEN + 1, intTemp - m_INFO_LEN - 1))
  Else
    Stop
  End If
  
  ExtractPlayerEmail = strTemp
End Function

Private Function TryAddNewPlayer(Email, IDType As m_enPlayerIDType, Optional NumericID As String) As clsPlayer
  'Try and add a new player object, if not, try and update an existing player object.
  Dim tmpPlayer As clsPlayer
  Set tmpPlayer = New clsPlayer
  Dim lngCnt As Long
  Dim strTemp As String
  Dim boFound As Boolean
    'When adding players the order goes...
    'Add email
    'Add ID to email
    'Add name
    'Add name and ID to email
    'Add email and ID to complete.
    'Never add email to the ID collection nor ID to the name
    'If we have both email and ID start with an email collection memeber
    'We always add an email member to the complete collection.
    
    'Search the "complete" player collection.  If not found add the new player to the right collection.
    Select Case IDType
      Case m_enPlayerIDType.enEmail
        Stop
  
      Case m_enPlayerIDType.enNumericID
        Stop
      
      Case m_enPlayerIDType.enName
        Stop
      
      Case m_enPlayerIDType.enEmailAndID
        'Try to find player in email collection first
        For Each tmpPlayer In m_colEmailPlayers
          If tmpPlayer.Email = Email Then
            'Stop
            boFound = True
            tmpPlayer.NumberOfAccounts = tmpPlayer.NumberOfAccounts + 1
            Exit For
          End If
        Next tmpPlayer
        
        'If we didn't find them then they must be a new player.
        If Not boFound Then
          Set tmpPlayer = New clsPlayer
          
          'Add new object to email collection
          tmpPlayer.Init NumericID
          tmpPlayer.Email = Email
            
          On Error Resume Next
          m_colEmailPlayers.Add tmpPlayer, Email
          Set tmpPlayer = Nothing
          m_clsSummary.IncrementPlayers
        End If
    End Select
    
  
  Set TryAddNewPlayer = tmpPlayer
  Set tmpPlayer = Nothing
  
End Function

Private Function CheckForConnectStep(LogLine As String, ConnectStepReturn) As Integer
  'Check if current line is a connect step line.
  'If so, set the currentStepIndicator
  
  If InStr(1, LogLine, m_CONNECT_1_OF_5) Then
    ConnectStepReturn = 1
  ElseIf InStr(1, LogLine, m_CONNECT_2_OF_5) Then
    ConnectStepReturn = 2
  ElseIf InStr(1, LogLine, m_CONNECT_3_OF_5) Then
    ConnectStepReturn = 3
  ElseIf InStr(1, LogLine, m_CONNECT_4_OF_5) Then
    ConnectStepReturn = 4
  ElseIf InStr(1, LogLine, m_CONNECT_5_OF_5) Then
    ConnectStepReturn = 5
  Else
    ConnectStepReturn = 0
  End If
  CheckForConnectStep = ConnectStepReturn
End Function

Private Function HandleConnectStep(LogLine As String, CurrentStep As Integer) As String
  'Now process connect step, if last step then return email and clear
  ' temp step from temp connect collection.  The collection is used in case of
  ' multithreading collisions.
  Dim strID As String
  Dim strSwitch1 As String
  Dim strEmail As String
  Dim strTemp As String
  Dim objTempLoginMatchup As New clsTempLoginMatchup
  
  Exit Function
  
  Select Case CurrentStep
    Case 1 'Add - contains ID
      objTempLoginMatchup.Step1 = True
      objTempLoginMatchup.NumericID = Mid(LogLine, Len(m_CONNECT_1_OF_5) + 1, Len(LogLine) - Len(m_CONNECT_1_OF_5) - 1)
      
      If m_colTempLoginMatchup.Count > 0 Then
        'Add to the end of the collection.. FIFO
        m_colTempLoginMatchup.Add objTempLoginMatchup, objTempLoginMatchup.NumericID, 1
      Else
        'First item in the collection...
        m_colTempLoginMatchup.Add objTempLoginMatchup, objTempLoginMatchup.NumericID
      End If

    Case 2 'Update - contains ID
      'Get ID from line first...
      strID = Mid(LogLine, Len(m_CONNECT_2_OF_5) + 1, Len(LogLine) - Len(m_CONNECT_2_OF_5) - 1)
      
      'Find the item in the collection as it should be there ...
      m_colTempLoginMatchup(strID).Step2 = True
      
    
    Case 3 'Update - contains ID
      'Get ID from line first...
      strID = Mid(LogLine, Len(m_CONNECT_3_OF_5) + 1, Len(LogLine) - Len(m_CONNECT_3_OF_5) - 1)
      
      'Find the item in the collection as it should be there ...
      m_colTempLoginMatchup(strID).Step3 = True
    
    Case 4 'Update - contains Switch#
      'Always assign the Switch Number to the first item in the collection
      ' as we always go FIFO.
      strID = Mid(LogLine, Len(m_CONNECT_4_OF_5) + 1, Len(LogLine) - Len(m_CONNECT_4_OF_5))
      m_colTempLoginMatchup(1).SwitchNum = strID
    
    Case 5 'Extract email and remove item based on a matching Switch#
      Dim intPos As Integer
      Dim intPos2 As Integer
      strID = ""
      'Find where the Connect5 string starts
      intPos = InStr(1, LogLine, m_CONNECT_5_OF_5)
      'Look for the text that starts after the switch #
      intPos2 = InStr(1, LogLine, "and ObjectID: 4")
      'First get the Switch Number
      strSwitch1 = Mid(LogLine, intPos + Len(m_CONNECT_5_OF_5), Len(LogLine) - Len(m_CONNECT_5_OF_5) - intPos - 15)
      Set objTempLoginMatchup = Nothing
      'Now we must assume that the switch # is unique and that 2 players cannot be on the same switch.
      For Each objTempLoginMatchup In m_colTempLoginMatchup
        'Try to find a match on the switch...
        If objTempLoginMatchup.SwitchNum = strSwitch1 Then
          strID = objTempLoginMatchup.NumericID
          'Extract email...
          strEmail = ExtractPlayerEmail(LogLine)
          Exit For
        End If
      Next objTempLoginMatchup
      'strid =
  End Select
  
  'If we found and email then we can try to add the player to the collection
  If Len(strEmail) > 0 Then
    TryAddNewPlayer strEmail, enEmailAndID, strID
    ProcessPlayerLogonStep 1, strEmail
    m_colTempLoginMatchup.Remove strID
  End If
  
  
End Function

Private Sub UpdateCurrentTurn(LogLine As String)
  'Stop
End Sub

Private Function HandleMM(LogLine As String)

End Function
Private Function HandleFCC(LogLine As String)

End Function
Private Function HandleCM(LogLine As String)

End Function
Private Function HandleMC(LogLine As String)

End Function
Private Function CheckPlayerLogout(ByRef LogoutStepFound As Integer, LogLine As String) As String
  Dim strEmail As String
  Dim intPos As Integer
  
  If InStr(m_INFO_LEN, LogLine, m_LOGOUT_1_OF_13) Then
    intPos = InStr(m_INFO_LEN, LogLine, m_LOGOUT_1_OF_13)
    strEmail = Trim(Mid(LogLine, m_INFO_LEN + 1, intPos - m_INFO_LEN - 1))
    LogoutStepFound = 1
  ElseIf InStr(m_INFO_LEN, LogLine, m_LOGOUT_2_OF_13) Then
    intPos = InStr(m_INFO_LEN, LogLine, m_LOGOUT_2_OF_13)
    strEmail = Trim(Mid(LogLine, m_INFO_LEN + 1, intPos - m_INFO_LEN - 1))
    LogoutStepFound = 2
  ElseIf InStr(m_INFO_LEN, LogLine, m_LOGOUT_3_OF_13) Then
    intPos = InStr(m_INFO_LEN, LogLine, m_LOGOUT_3_OF_13)
    strEmail = Trim(Mid(LogLine, m_INFO_LEN + 1, intPos - m_INFO_LEN - 1))
    LogoutStepFound = 3
  ElseIf InStr(m_INFO_LEN, LogLine, m_LOGOUT_4_OF_13) Then
    intPos = InStr(m_INFO_LEN, LogLine, m_LOGOUT_4_OF_13)
    strEmail = Trim(Mid(LogLine, m_INFO_LEN + 1, intPos - m_INFO_LEN - 1))
    LogoutStepFound = 4
  ElseIf InStr(m_INFO_LEN, LogLine, m_LOGOUT_5_OF_13) Then
    intPos = InStr(m_INFO_LEN, LogLine, m_LOGOUT_5_OF_13)
    strEmail = Trim(Mid(LogLine, m_INFO_LEN + 1, intPos - m_INFO_LEN - 1))
    LogoutStepFound = 5
  ElseIf InStr(m_INFO_LEN, LogLine, m_LOGOUT_6_OF_13) Then
    intPos = InStr(m_INFO_LEN, LogLine, m_LOGOUT_6_OF_13)
    strEmail = Trim(Mid(LogLine, m_INFO_LEN + 1, intPos - m_INFO_LEN - 1))
    LogoutStepFound = 6
  ElseIf InStr(m_INFO_LEN, LogLine, m_LOGOUT_7_OF_13) Then
    intPos = InStr(m_INFO_LEN, LogLine, m_LOGOUT_7_OF_13)
    strEmail = Trim(Mid(LogLine, m_INFO_LEN + 1, intPos - m_INFO_LEN - 1))
    LogoutStepFound = 7
  ElseIf InStr(m_INFO_LEN, LogLine, m_LOGOUT_8_OF_13) Then
    intPos = InStr(m_INFO_LEN, LogLine, m_LOGOUT_8_OF_13)
    strEmail = Trim(Mid(LogLine, m_INFO_LEN + 1, intPos - m_INFO_LEN - 1))
    LogoutStepFound = 8
  ElseIf InStr(m_INFO_LEN, LogLine, m_LOGOUT_9_OF_13) Then
    intPos = InStr(m_INFO_LEN, LogLine, m_LOGOUT_9_OF_13)
    strEmail = Trim(Mid(LogLine, m_INFO_LEN + 1, intPos - m_INFO_LEN - 1))
    LogoutStepFound = 9
  ElseIf InStr(m_INFO_LEN, LogLine, m_LOGOUT_10_OF_13) Then
    intPos = InStr(m_INFO_LEN, LogLine, m_LOGOUT_10_OF_13)
    strEmail = Trim(Mid(LogLine, m_INFO_LEN + 1, intPos - m_INFO_LEN - 1))
    LogoutStepFound = 10
  ElseIf InStr(m_INFO_LEN, LogLine, m_LOGOUT_11_OF_13) Then
    intPos = InStr(m_INFO_LEN, LogLine, m_LOGOUT_11_OF_13)
    strEmail = Trim(Mid(LogLine, m_INFO_LEN + 1, intPos - m_INFO_LEN - 1))
    LogoutStepFound = 11
  ElseIf InStr(m_INFO_LEN, LogLine, m_LOGOUT_12_OF_13) Then
    intPos = InStr(m_INFO_LEN, LogLine, m_LOGOUT_12_OF_13)
    strEmail = Trim(Mid(LogLine, m_INFO_LEN + 1, intPos - m_INFO_LEN - 1))
    LogoutStepFound = 12
  ElseIf InStr(m_INFO_LEN, LogLine, m_LOGOUT_13_OF_13) Then
    intPos = InStr(m_INFO_LEN, LogLine, m_LOGOUT_13_OF_13)
    strEmail = Trim(Mid(LogLine, m_INFO_LEN + 1, intPos - m_INFO_LEN - 1))
    LogoutStepFound = 13
  Else
    'did not qualify for a match...
    strEmail = "-1"
    LogoutStepFound = 0
  End If

  CheckPlayerLogout = strEmail
End Function
Private Sub CompletePlayerObject(LogLine As String, Filter As String)
  'We can assume that this line has a player name in it.
  'Now we can complete a player object and remove them from the email object.
  Dim tmpPlayer As clsPlayer
  Dim strID As String
  Dim strName As String
  Dim boFound As Boolean
  
  strName = ExtractPlayerName(LogLine, Filter)
  strID = ExtractPlayerID(LogLine)
  
  'Try to get player from collection, it they don't exist, tmpPlayer will still be nothing
  On Error Resume Next
  Set tmpPlayer = m_colCompletePlayers(strID)
  
  
  If tmpPlayer Is Nothing Then
    'Create new player and add them to the collection
    Set tmpPlayer = New clsPlayer
    tmpPlayer.Init strID
    tmpPlayer.PlayerName = strName
    m_colCompletePlayers.Add tmpPlayer, strID
    Set tmpPlayer = m_colCompletePlayers(strID)
  End If
  
  'Increment their move counter
  tmpPlayer.IncrementMoves
  
  'For Each tmpPlayer In m_colCompletePlayers
  '  If tmpPlayer.PlayerName = strName Then
  '    boFound = True
  '  End If
  'Next tmpPlayer
  
   
'  If Not boFound Then
'    strID = ExtractPlayerID(LogLine)
'    Find the player by the current ID then add the name and move them
'     to complete and kill the email version.
'    For Each tmpPlayer In m_colEmailPlayers
'      If tmpPlayer.ID = strID Then
'        tmpPlayer.PlayerName = strName
'        m_colCompletePlayers.Add tmpPlayer, strName
'        m_colEmailPlayers.Remove tmpPlayer.Email
'      End If
'    Next tmpPlayer
'  End If
  
End Sub
Private Function ExtractPlayerName(LogLine, Optional Filter As String) As String
  Dim strName As String
  Dim intTemp As Integer
  Dim strMarker As String
  Dim intPos As Integer
  strMarker = ")"
  
  intTemp = InStr(m_INFO_MM_LEN, LogLine, ":")
  intPos = InStr(intTemp, LogLine, strMarker)
  
  strName = Mid(LogLine, intTemp + 1, intPos - intTemp - 1)
  
  ExtractPlayerName = strName
End Function
Private Sub ForfeitDraft(LogLine As String, Filter As String)
  Dim tmpPlayer As clsPlayer
  Dim strName As String
  Dim strID As String
  
  strName = ExtractPlayerName(LogLine, Filter)
  strID = ExtractPlayerID(LogLine)
  
  Set tmpPlayer = m_colCompletePlayers(strID)
  tmpPlayer.IncrementForfeitDrafts
  tmpPlayer.PlayerName = strName
  
  
End Sub
Private Sub InitiatedMission(LogLine As String)
  Dim tmpPlayer As clsPlayer
  Dim strName As String
  Dim strID As String
  On Error Resume Next
  strName = ExtractPlayerName(LogLine)
  strID = ExtractPlayerID(LogLine)
  
  Set tmpPlayer = m_colCompletePlayers(strID)
  tmpPlayer.IncrementMissionsInitiated
  tmpPlayer.PlayerName = strName
End Sub
Private Sub ProcessAIOnlyMission(LogLine As String)
  Dim tmpPlayer As clsPlayer
  Dim strName As String
  Dim strID As String
  
  On Error Resume Next
  strName = ExtractPlayerName(LogLine)
  strID = ExtractPlayerID(LogLine)
  
  Set tmpPlayer = m_colCompletePlayers(strID)
  tmpPlayer.IncrementAIOnlyMissions
  tmpPlayer.PlayerName = strName
  
End Sub

Private Sub DraftingHumans(LogLine As String)
  Dim tmpPlayer As clsPlayer
  Dim strName As String
  Dim strID As String
  Dim strDraftedID As String
  
  strName = ExtractPlayerName(LogLine)
  strID = ExtractPlayerID(LogLine)
  strDraftedID = ExtractDraftedID(LogLine)
  
  Set tmpPlayer = m_colCompletePlayers(strID)
  tmpPlayer.IncrementNumHumansDrafted
  
  Set tmpPlayer = Nothing
  
  On Error Resume Next
  Set tmpPlayer = m_colCompletePlayers(strDraftedID)
  
  'If no object was found, then add them to the collection first (without a name)
  If tmpPlayer Is Nothing Then
    'Create new player and add them to the collection
    Set tmpPlayer = New clsPlayer
    tmpPlayer.Init strID
    'tmpPlayer.PlayerName = strName
    m_colCompletePlayers.Add tmpPlayer, strDraftedID
    Set tmpPlayer = m_colCompletePlayers(strDraftedID)
  End If
  tmpPlayer.IncrementTimesDrafted
  
End Sub

Private Sub AcceptedDraft(LogLine As String)
  Dim tmpPlayer As clsPlayer
  Dim strName As String
  Dim strID As String
  On Error Resume Next
  strID = ExtractDraftAcceptedID(LogLine)
  
  Set tmpPlayer = m_colCompletePlayers(strID)
  tmpPlayer.AcceptedDraft
  
End Sub

Private Sub MissionComplete(LogLine As String)
  Dim tmpPlayer As clsPlayer
  Dim strName As String
  Dim strID As String
  Dim strTeamID As String
  
  strName = ExtractPlayerName(LogLine)
  strID = ExtractPlayerID(LogLine)
  strTeamID = ExtractTeamID(LogLine)
  
  On Error Resume Next
  Set tmpPlayer = m_colCompletePlayers(strID)
  tmpPlayer.IncrementMissionsComplete
  
  If Len(strTeamID) > 0 Then
    On Error Resume Next
    Set tmpPlayer = m_colCompletePlayers(strTeamID)
    
    If tmpPlayer Is Nothing Then Exit Sub
    tmpPlayer.IncrementMissionsComplete
  End If
End Sub
