VERSION 1.0 CLASS
BEGIN
  MultiUse = -1  'True
  Persistable = 0  'NotPersistable
  DataBindingBehavior = 0  'vbNone
  DataSourceBehavior  = 0  'vbNone
  MTSTransactionMode  = 0  'NotAnMTSObject
END
Attribute VB_Name = "clsPlayer"
Attribute VB_GlobalNameSpace = False
Attribute VB_Creatable = True
Attribute VB_PredeclaredId = False
Attribute VB_Exposed = False
Option Explicit

Private Enum enActionType
  enone = 0
  eLogon
  eCreatingAccount
  eLogout
  eDraftingHumans
  eDrafted
  eInMission
  
End Enum

Private m_strEmail As String
Private m_strID As Long
Private m_arrLogonSteps(13) As Boolean '14 elements, zero based 0-13
Private m_intActionInProgress As enActionType
Private m_intGoodLogonCnt As Integer
Private m_intBadLogonCnt As Integer
Private m_intActionConflicts As Integer
Private m_intNumAccounts As Integer
Private m_boLoggedIn As Boolean
Private m_intNumLogOuts As Integer
Private m_arrLogoutSteps(13) As Boolean
Private m_strName As String
Private m_intForfeitDrafts As Integer
Private m_intNumMoves As Integer
Private m_intMissionsInitiated As Integer
Private m_intAIOnlyMissions As Integer
Private m_intNumDraftedHumans As Integer
Private m_intPvPWithOne As Integer
Private m_intPvPWithTwo As Integer
Private m_intPvPWithThree As Integer
Private m_intPvPWithFour As Integer
Private m_intPvPWithFive As Integer
Private m_intPvPWithSix As Integer
Private m_intPvPMissions As Integer
Private m_intTimesDrafted As Integer
Private m_intDrops As Integer
Private m_intDraftDodges As Integer
Private m_intNumMissionsCompete As Integer



' PROPERTIES *************************************************
Public Property Get MissionsInitiated() As Integer
  MissionsInitiated = m_intMissionsInitiated
End Property
Public Property Get ForfeitDrafts() As Integer
  ForfeitDrafts = m_intForfeitDrafts
End Property

Public Property Get PlayerName() As String
  PlayerName = m_strName
End Property
Public Property Let PlayerName(value As String)
  m_strName = value
End Property
  
Public Property Get NumLogOuts() As Integer
  NumLogOuts = m_intNumLogOuts
End Property
Public Property Get LoggedIn() As Boolean
  LoggedIn = m_boLoggedIn
End Property
Public Property Get NumberOfAccounts() As Integer
  NumberOfAccounts = m_intNumAccounts
End Property
Public Property Let NumberOfAccounts(value As Integer)
  m_intNumAccounts = value
End Property
Public Property Get ActionConflicts() As Integer
  ActionConflicts = m_intActionConflicts
End Property
Public Property Get GoodLogons() As Integer
  GoodLogons = m_intGoodLogonCnt
End Property
Public Property Get BadLogons() As Integer
  BadLogons = m_intBadLogonCnt
End Property
Public Property Let SetLogoutStep(Step As Integer)
  Step = Step - 1 'for zero based array
  CancelLogin
  CheckActions eLogout
  m_arrLogoutSteps(Step) = True
  CheckIsLogoutComplete
End Property

Public Property Let SetLogonStep(Step As Integer)
  If Not m_intActionInProgress = enActionType.eLogout Then
    Step = Step - 1 'for zero based array
    CheckActions eLogon
    m_arrLogonSteps(Step) = True
    CheckIsLogonComplete
  End If
End Property
Public Property Get ID() As String
  ID = m_strID
End Property
Public Property Get Email() As String
  Email = m_strEmail
End Property
Public Property Let Email(value As String)
  m_strEmail = value
End Property
Public Property Get NumMoves() As Integer
  NumMoves = m_intNumMoves
End Property
'Public Property Let NumMoves(value As Integer)
'  m_intNumMoves = value
'End Property
Public Property Get NumAIOnlyMissions() As Integer
  NumAIOnlyMissions = m_intAIOnlyMissions
End Property
Public Property Get NumDraftedHumans() As Integer
  NumDraftedHumans = m_intNumDraftedHumans
End Property
Public Property Get NumPvPMissions() As Integer
  NumPvPMissions = m_intPvPMissions
End Property
Public Property Get NumPvPWithOne() As Integer
  NumPvPWithOne = m_intPvPWithOne
End Property
Public Property Get NumPvPWithTwo() As Integer
  NumPvPWithTwo = m_intPvPWithTwo
End Property
Public Property Get NumPvPWithThree() As Integer
  NumPvPWithThree = m_intPvPWithThree
End Property
Public Property Get NumPvPWithFour() As Integer
  NumPvPWithFour = m_intPvPWithFour
End Property
Public Property Get NumPvPWithFive() As Integer
  NumPvPWithFive = m_intPvPWithFive
End Property
Public Property Get NumPvPWithSix() As Integer
  NumPvPWithSix = m_intPvPWithSix
End Property
Public Property Get NumTimesDrafted() As Integer
  NumTimesDrafted = m_intTimesDrafted
End Property
Public Property Get NumDrops() As Integer
  NumDrops = m_intDrops
End Property
Public Property Get NumDraftDodges() As Integer
  NumDraftDodges = m_intDraftDodges
End Property
Public Property Get NumMissionsComplete() As Integer
  NumMissionsComplete = m_intNumMissionsCompete
End Property

' FUNCTIONS *************************************************
Public Sub IncrementMissionsInitiated()
  m_intMissionsInitiated = m_intMissionsInitiated + 1
  'Count drafted and increment as necessary else it's just an AI mission
  If m_intNumDraftedHumans > 0 Then
    Select Case m_intNumDraftedHumans
      Case 1
        m_intPvPWithOne = m_intPvPWithOne + 1
      Case 2
        m_intPvPWithTwo = m_intPvPWithTwo + 1
      Case 3
        m_intPvPWithThree = m_intPvPWithThree + 1
      Case 4
        m_intPvPWithFour = m_intPvPWithFour + 1
      Case 5
        m_intPvPWithFive = m_intPvPWithFive + 1
      Case 6
        m_intPvPWithSix = m_intPvPWithSix + 1

    End Select
    m_intNumDraftedHumans = 0
  End If
End Sub
Public Sub IncrementForfeitDrafts()
  m_intForfeitDrafts = m_intForfeitDrafts + 1
End Sub
Public Sub IncrementMoves()
  Dim tmp As enActionType
  tmp = CheckActions(enone)
  m_intNumMoves = m_intNumMoves + 1
  If tmp = eDrafted Then
    IncrementDraftDodges
  End If
End Sub
Public Sub IncrementAIOnlyMissions()
  m_intAIOnlyMissions = m_intAIOnlyMissions + 1
End Sub
Public Sub IncrementNumHumansDrafted()
  m_intNumDraftedHumans = m_intNumDraftedHumans + 1
End Sub
Public Sub IncrementPvPMissions()
  m_intPvPMissions = m_intPvPMissions + 1
End Sub
Public Sub IncrementTimesDrafted()
  m_intActionInProgress = eDrafted
  m_intTimesDrafted = m_intTimesDrafted + 1
End Sub
Public Sub IncrementDrops()
  m_intDrops = m_intDrops + 1
End Sub
Public Sub IncrementDraftDodges()
  m_intDraftDodges = m_intDraftDodges + 1
End Sub
Public Sub IncrementMissionsComplete()
  'Only increment if action is "in mission"
  If m_intActionInProgress = eInMission Then
    m_intNumMissionsCompete = m_intNumMissionsCompete + 1
  End If
  CheckActions (eInMission)
  m_intActionInProgress = enone
End Sub


Public Sub Init(ID As String)
  m_strID = ID
End Sub
Public Sub AcceptedDraft()
  CheckActions (eDrafted)
  m_intActionInProgress = eInMission
  
End Sub
Private Sub CheckIsLogonComplete()
  'Check all logon states.  If they are all true then a logon has been completed
  'If not and another action has happened then we have an error.
  Dim iCnt As Integer
  Dim intTrueCnt As Integer
  
  For iCnt = 0 To 13
    If m_arrLogonSteps(iCnt) Then
      intTrueCnt = intTrueCnt + 1
    Else
      Exit For
    End If
  Next iCnt
  
  If intTrueCnt = 1 Then
    m_intGoodLogonCnt = m_intGoodLogonCnt + 1
    'Reset logon steps to all false
    For iCnt = 0 To 13
      m_arrLogonSteps(iCnt) = False
    Next iCnt
    If m_intActionInProgress = enActionType.eLogon Then
      m_intActionInProgress = enActionType.enone
    End If
  Else
    m_intActionInProgress = enActionType.eLogon
  End If
  
End Sub
Private Sub CheckIsLogoutComplete()
  'Check all logout states.  If they are all true then a logout has been completed
  'If not and another action has happened then we have an error.
  Dim iCnt As Integer
  Dim intTrueCnt As Integer
  
  For iCnt = 0 To 12
    If m_arrLogoutSteps(iCnt) Then
      intTrueCnt = intTrueCnt + 1
    Else
      Exit For
    End If
  Next iCnt
  
  If intTrueCnt = 13 Then
    m_intNumLogOuts = m_intNumLogOuts + 1
    'Reset logon steps to all false
    For iCnt = 0 To 12
      m_arrLogoutSteps(iCnt) = False
    Next iCnt
    m_intActionInProgress = enActionType.enone
    m_boLoggedIn = False
  Else
    m_intActionInProgress = enActionType.eLogout
  End If
End Sub
Private Function CheckActions(CurrentAction As enActionType) As enActionType
  CheckActions = m_intActionInProgress
  If Not (m_intActionInProgress = enActionType.enone Or m_intActionInProgress = CurrentAction) Then
    'We have an error as the current action is not the same as the previously logged
    'action in progress.  We will then update to the current action and abandon the
    'last one.
    m_intActionConflicts = m_intActionConflicts + 1
    m_intActionInProgress = CurrentAction
  End If
End Function
Private Sub CancelLogin()
  'This will get called when a logout is detected
  'Since some of the login code is repeated when loggin out
  ' we assume that if we are logging out then we must
  ' cancel any login process.
  Dim intCnt As Integer
  For intCnt = 0 To 13
    m_arrLogonSteps(intCnt) = False
  Next intCnt
  m_intActionInProgress = eLogout
End Sub
