VERSION 5.00
Object = "{F9043C88-F6F2-101A-A3C9-08002B2F49FB}#1.2#0"; "COMDLG32.OCX"
Object = "{C8530F8A-C19C-11D2-99D6-9419F37DBB29}#1.1#0"; "ccrpprg6.ocx"
Object = "{BDC217C8-ED16-11CD-956C-0000C04E4C0A}#1.1#0"; "TABCTL32.OCX"
Begin VB.Form frmMain 
   Caption         =   "SFC2 EAW Log File Parser"
   ClientHeight    =   7275
   ClientLeft      =   60
   ClientTop       =   345
   ClientWidth     =   9015
   LinkTopic       =   "Form1"
   LockControls    =   -1  'True
   ScaleHeight     =   7275
   ScaleWidth      =   9015
   StartUpPosition =   2  'CenterScreen
   Begin VB.CommandButton cmdExport 
      Caption         =   "&Export"
      Height          =   390
      Left            =   2505
      TabIndex        =   12
      Top             =   6855
      Width           =   1140
   End
   Begin TabDlg.SSTab tabInfo 
      Height          =   5415
      Left            =   105
      TabIndex        =   9
      Top             =   120
      Width           =   8745
      _ExtentX        =   15425
      _ExtentY        =   9551
      _Version        =   393216
      Style           =   1
      Tabs            =   5
      Tab             =   2
      TabsPerRow      =   5
      TabHeight       =   520
      TabCaption(0)   =   "&Log File Contents"
      TabPicture(0)   =   "frmMain.frx":0000
      Tab(0).ControlEnabled=   0   'False
      Tab(0).Control(0)=   "txtLogFile"
      Tab(0).ControlCount=   1
      TabCaption(1)   =   "&Server Info"
      TabPicture(1)   =   "frmMain.frx":001C
      Tab(1).ControlEnabled=   0   'False
      Tab(1).Control(0)=   "txtServerInfo"
      Tab(1).ControlCount=   1
      TabCaption(2)   =   "&Player Info"
      TabPicture(2)   =   "frmMain.frx":0038
      Tab(2).ControlEnabled=   -1  'True
      Tab(2).Control(0)=   "txtPlayerInfo"
      Tab(2).Control(0).Enabled=   0   'False
      Tab(2).ControlCount=   1
      TabCaption(3)   =   "E&rrors"
      TabPicture(3)   =   "frmMain.frx":0054
      Tab(3).ControlEnabled=   0   'False
      Tab(3).Control(0)=   "txtErrors"
      Tab(3).ControlCount=   1
      TabCaption(4)   =   "&Summary"
      TabPicture(4)   =   "frmMain.frx":0070
      Tab(4).ControlEnabled=   0   'False
      Tab(4).Control(0)=   "txtSummary"
      Tab(4).ControlCount=   1
      Begin VB.TextBox txtSummary 
         BackColor       =   &H8000000F&
         Height          =   4860
         Left            =   -74880
         Locked          =   -1  'True
         MultiLine       =   -1  'True
         ScrollBars      =   3  'Both
         TabIndex        =   15
         Text            =   "frmMain.frx":008C
         Top             =   420
         Width           =   8460
      End
      Begin VB.TextBox txtErrors 
         BackColor       =   &H8000000F&
         Height          =   4860
         Left            =   -74880
         Locked          =   -1  'True
         MultiLine       =   -1  'True
         ScrollBars      =   3  'Both
         TabIndex        =   14
         Text            =   "frmMain.frx":00F4
         Top             =   420
         Width           =   8460
      End
      Begin VB.TextBox txtPlayerInfo 
         BackColor       =   &H8000000F&
         BeginProperty Font 
            Name            =   "Courier New"
            Size            =   8.25
            Charset         =   0
            Weight          =   400
            Underline       =   0   'False
            Italic          =   0   'False
            Strikethrough   =   0   'False
         EndProperty
         Height          =   4860
         Left            =   120
         Locked          =   -1  'True
         MultiLine       =   -1  'True
         ScrollBars      =   3  'Both
         TabIndex        =   13
         Text            =   "frmMain.frx":015C
         Top             =   420
         Width           =   8460
      End
      Begin VB.TextBox txtServerInfo 
         BackColor       =   &H8000000F&
         Height          =   4860
         Left            =   -74880
         Locked          =   -1  'True
         MultiLine       =   -1  'True
         ScrollBars      =   3  'Both
         TabIndex        =   11
         Text            =   "frmMain.frx":01C4
         Top             =   420
         Width           =   8460
      End
      Begin VB.TextBox txtLogFile 
         BackColor       =   &H8000000F&
         Height          =   4860
         Left            =   -74880
         Locked          =   -1  'True
         MultiLine       =   -1  'True
         ScrollBars      =   3  'Both
         TabIndex        =   10
         Text            =   "frmMain.frx":022C
         Top             =   420
         Width           =   8460
      End
   End
   Begin CCRProgressBar6.ccrpProgressBar prgParseProgress 
      Height          =   300
      Left            =   105
      Top             =   5640
      Width           =   8745
      _ExtentX        =   15425
      _ExtentY        =   529
      Caption         =   "Parsing Progress 0% (Not Started)"
      BeginProperty Font {0BE35203-8F91-11CE-9DE3-00AA004BB851} 
         Name            =   "MS Sans Serif"
         Size            =   8.25
         Charset         =   0
         Weight          =   400
         Underline       =   0   'False
         Italic          =   0   'False
         Strikethrough   =   0   'False
      EndProperty
      Smooth          =   -1  'True
   End
   Begin VB.CommandButton cmdExit 
      Cancel          =   -1  'True
      Caption         =   "E&xit"
      Height          =   390
      Left            =   7755
      TabIndex        =   2
      Top             =   6855
      Width           =   1140
   End
   Begin VB.CommandButton cmdFullParse 
      Caption         =   "&Full Parse"
      Height          =   390
      Left            =   1290
      TabIndex        =   1
      Top             =   6855
      Width           =   1140
   End
   Begin MSComDlg.CommonDialog diaDialog 
      Left            =   4515
      Top             =   6255
      _ExtentX        =   847
      _ExtentY        =   847
      _Version        =   393216
   End
   Begin VB.CommandButton cmdOpenFile 
      Caption         =   "&Open File"
      Height          =   390
      Left            =   75
      TabIndex        =   0
      Top             =   6855
      Width           =   1140
   End
   Begin VB.Label lblNumberofLines 
      AutoSize        =   -1  'True
      Caption         =   "0"
      Height          =   195
      Left            =   1545
      TabIndex        =   8
      Top             =   6600
      Width           =   90
   End
   Begin VB.Label Label4 
      AutoSize        =   -1  'True
      Caption         =   "Number of lines:"
      Height          =   195
      Left            =   90
      TabIndex        =   7
      Top             =   6585
      Width           =   1140
   End
   Begin VB.Label lblFileSize 
      AutoSize        =   -1  'True
      Caption         =   "0k"
      Height          =   195
      Left            =   1545
      TabIndex        =   6
      Top             =   6345
      Width           =   180
   End
   Begin VB.Label Label2 
      AutoSize        =   -1  'True
      Caption         =   "File Size:"
      Height          =   195
      Left            =   90
      TabIndex        =   5
      Top             =   6330
      Width           =   630
   End
   Begin VB.Label lblLogFilePath 
      AutoSize        =   -1  'True
      Caption         =   "None selected."
      Height          =   195
      Left            =   1545
      TabIndex        =   4
      Top             =   6075
      Width           =   1080
   End
   Begin VB.Label Label1 
      AutoSize        =   -1  'True
      Caption         =   "Log File Path:"
      Height          =   195
      Left            =   90
      TabIndex        =   3
      Top             =   6060
      Width           =   975
   End
End
Attribute VB_Name = "frmMain"
Attribute VB_GlobalNameSpace = False
Attribute VB_Creatable = False
Attribute VB_PredeclaredId = True
Attribute VB_Exposed = False
Option Explicit


Private m_strFileName As String
Private m_lngFileSize As Long
Private m_lngLineCount As Long
Private m_intFileNumber As Integer
Const m_AVG_BYTES_PER_LINE As Integer = 58

Public Property Get FileNumber() As String
  FileNumber = m_intFileNumber
End Property

Public Property Get LineCount() As Long
  LineCount = m_lngLineCount
End Property

Public Property Get FileSize() As Long
  FileSize = m_lngFileSize
End Property

Public Property Get FileName() As String
  FileName = m_strFileName
End Property

Private Sub cmdExit_Click()
  Unload Me
End Sub

Private Sub cmdFullParse_Click()
  Dim objParseEngine As New clsParseEngine
  Dim tmpSummary As clsSummary
  Dim colPlayers As Collection
  
  Close m_intFileNumber
  m_intFileNumber = FreeFile()
  Open m_strFileName For Input As m_intFileNumber

  With objParseEngine
    .Init m_intFileNumber, prgParseProgress, m_lngLineCount
    .FullParse
    Set tmpSummary = .Summary
    Set colPlayers = .IncompletePlayers
  End With
  
  Me.prgParseProgress.Caption = "Done!"
  
  'Fill text boxes for viewing.
  With tmpSummary
    txtSummary.Text = "Blank Lines: " & .BlankLines _
      & vbNewLine & "Warnings: " & .Warnings _
      & vbNewLine & "Server Starts: " & .ServerStarts _
      & vbNewLine & "Player Accounts (by email at startup): " & .Players _
      & vbNewLine & "Client Queries " & .ClientQueries
    '.Text = .Text & vbnewline & tmpsummary.BlankLines
  End With
  Dim tmpPlayer As clsPlayer
'  For Each tmpPlayer In colPlayers
'    txtPlayerInfo.Text = txtPlayerInfo.Text & tmpPlayer.Email & _
'      " *** Conflicts: " & tmpPlayer.ActionConflicts + tmpPlayer.BadLogons & _
'      " *** Good Logons: " & tmpPlayer.GoodLogons & _
'      " *** Logouts: " & tmpPlayer.NumLogOuts & vbNewLine
'  Next tmpPlayer
  
  Set colPlayers = objParseEngine.Players
  txtPlayerInfo.Text = ""
    txtPlayerInfo.Text = txtPlayerInfo.Text & _
      "Name: " & Space(40) & _
      vbTab & "Conflicts: " & _
      vbTab & "Forfeit Drafts: " & _
      vbTab & "Missions Initiated: " & _
      vbTab & "Moves: " & _
      vbTab & "AI Only Missions: " & _
      vbTab & "PvP 1: " & _
      vbTab & "PvP 2: " & _
      vbTab & "PvP 3: " & _
      vbTab & "PvP 4: " & _
      vbTab & "PvP 5: " & _
      vbTab & "PvP 6: " & _
      vbTab & "Times Drafted: " & _
      vbTab & "Draft Dodges: " & _
      vbTab & "Missions Complete: " & _
      vbNewLine
  For Each tmpPlayer In colPlayers
    txtPlayerInfo.Text = txtPlayerInfo.Text & _
      Mid(tmpPlayer.PlayerName & Space(40 - Len(tmpPlayer.PlayerName)), 1, 40) & _
      vbTab & tmpPlayer.ActionConflicts & _
      vbTab & tmpPlayer.ForfeitDrafts & _
      vbTab & tmpPlayer.MissionsInitiated & _
      vbTab & tmpPlayer.NumMoves & _
      vbTab & tmpPlayer.NumAIOnlyMissions & _
      vbTab & tmpPlayer.NumPvPWithOne & _
      vbTab & tmpPlayer.NumPvPWithTwo & _
      vbTab & tmpPlayer.NumPvPWithThree & _
      vbTab & tmpPlayer.NumPvPWithFour & _
      vbTab & tmpPlayer.NumPvPWithFive & _
      vbTab & tmpPlayer.NumPvPWithSix & _
      vbTab & tmpPlayer.NumTimesDrafted & _
      vbTab & tmpPlayer.NumDraftDodges & _
      vbTab & tmpPlayer.NumMissionsComplete & _
      vbNewLine
  Next tmpPlayer
  
  
  'Switch to the summary tab.
  Me.tabInfo.Tab = 4
  
End Sub

Private Sub cmdOpenFile_Click()
  ClosePrevious

  'Select and open File
  'Get file path, file size, line count, and set file number
    
  'Present user with open file dialog box.
  With diaDialog
    .DialogTitle = "Open a log file"
    .Filter = "LogFiles (*.log)|*.log|Text (*.txt)|*.txt|All Files (*.*)|*.*"
    .InitDir = App.Path & "\Logfiles"
    .ShowOpen 'Get filename
    m_strFileName = .FileName
  End With
  
  If Len(m_strFileName) = 0 Then
    MsgBox "No file selected.", vbExclamation
    Exit Sub
  End If
  
  Dim fsFileObject As Variant
  Dim varTemp As Variant
  Dim lngFileSize As Long
  Dim dblFileSize As Double
  Set fsFileObject = CreateObject("Scripting.FileSystemObject")
  
  lblLogFilePath.Caption = m_strFileName
  Set varTemp = fsFileObject.getfile(m_strFileName)
  m_lngFileSize = varTemp.Size
  dblFileSize = Format(m_lngFileSize / 1000000, "#,##0.00")
  lblFileSize.Caption = m_lngFileSize & " Bytes (" & dblFileSize & " MB)"
  
  Set fsFileObject = Nothing
  Set varTemp = Nothing
  
  m_intFileNumber = FreeFile()
  Open m_strFileName For Input As m_intFileNumber
  
  'Set up progress bar for reading lines
  Dim lngIncrement As Long
  prgParseProgress.Clear
  prgParseProgress.Max = m_lngFileSize / m_AVG_BYTES_PER_LINE
  lngIncrement = prgParseProgress.Max / 100
  prgParseProgress.IncrementSize = lngIncrement
  prgParseProgress.Caption = "Reading number of lines 0%"
  
  DoEvents
  
  'Get line count
  m_lngLineCount = g_GetLineCount(m_intFileNumber, prgParseProgress, lngIncrement)
  lblNumberofLines.Caption = Format(m_lngLineCount, "#,###,###,###,##0")
  
  DoEvents
  
  prgParseProgress.Clear
  prgParseProgress.Caption = "Ready to being parsing."
  
  Close m_intFileNumber
  Open m_strFileName For Input As m_intFileNumber
   
  'Get first 50 lines for summary box.
  txtLogFile.Text = g_GetFirst50Lines(m_intFileNumber)
  Close m_intFileNumber
  
End Sub


Private Sub ClosePrevious()
  'Clean up before opening a new session
  If m_intFileNumber > 0 Then
    Close m_intFileNumber
  End If
  m_strFileName = ""
  m_lngFileSize = 0
  m_lngLineCount = 0
  m_intFileNumber = 0
  
  lblLogFilePath.Caption = ""
  lblFileSize.Caption = ""
  lblNumberofLines.Caption = ""
  
  txtLogFile.Text = ""
  txtPlayerInfo.Text = ""
  txtServerInfo.Text = ""
  txtErrors.Text = ""
  
  With prgParseProgress
    .Clear
    .IncrementSize = 1
    .Max = 100
    .Min = 1

    .Caption = "Waiting..."
  End With
  
  
End Sub
