
CREATE TABLE battleparticipant (
  ID int(11) NOT NULL default '0',
  BattleID int(11) NOT NULL default '0',
  CharacterID int(11) NOT NULL default '0',
  MissionSlot int(11) NOT NULL default '0',
  VictoryLevel int(11) NOT NULL default '0',
  RegularPrestige int(11) NOT NULL default '0',
  BonusPrestige int(11) NOT NULL default '0',
  Medal int(11) NOT NULL default '0',
  CampaignEvent int(11) NOT NULL default '0',
  IsAI tinyint(1) NOT NULL default '0',
  PRIMARY KEY  (ID)
) TYPE=MyISAM;

CREATE TABLE battleparticipantships (
  BattleParticipantID int(11) NOT NULL default '0',
  BPV int(11) NOT NULL default '0',
  ShipClassName varchar(255) NOT NULL default '',
  DamagePercentAtEnd int(11) NOT NULL default '0',
  Destroyed tinyint(1) NOT NULL default '0'
) TYPE=MyISAM;

CREATE TABLE battles (
  ID int(11) NOT NULL default '0',
  LOCKED datetime default NULL,
  LOCKID int(11) default NULL,
  MissionName varchar(255) NOT NULL default '',
  BeginTime datetime NOT NULL default '0000-00-00 00:00:00',
  EndTime datetime NOT NULL default '0000-00-00 00:00:00',
  X int(11) NOT NULL default '0',
  Y int(11) NOT NULL default '0',
  HostID int(11) NOT NULL default '0',
  NumParticipants int(11) NOT NULL default '0',
  HexBeforeEmpireDV int(11) default NULL,
  HexBeforeCartelDV int(11) default NULL,
  HexBeforeEmpireRace int(11) default NULL,
  HexBeforeCartelRace int(11) default NULL,
  HexAfterEmpireDV int(11) default NULL,
  HexAfterCartelDV int(11) default NULL,
  HexAfterEmpireRace int(11) default NULL,
  HexAfterCartelRace int(11) default NULL,
  PRIMARY KEY  (ID)
) TYPE=MyISAM;

CREATE TABLE battlesrunning (
  ID int(11) NOT NULL default '0',
  LOCKED datetime default NULL,
  LOCKID int(11) default NULL,
  BeginTime int(11) NOT NULL default '0',
  MissionName varchar(255) NOT NULL default '',
  Participants varchar(255) NOT NULL default '',
  PRIMARY KEY  (ID)
) TYPE=MyISAM;

CREATE TABLE biditem (
  ID int(11) NOT NULL default '0',
  LOCKED datetime default NULL,
  LOCKID int(11) default NULL,
  BiddingHasBegun tinyint(1) NOT NULL default '0',
  ItemName varchar(255) NOT NULL default '',
  ItemID int(11) NOT NULL default '0',
  ItemInfo int(11) NOT NULL default '0',
  AuctionValue int(11) NOT NULL default '0',
  AuctionRate double NOT NULL default '0',
  TurnOpened int(11) NOT NULL default '0',
  TurnToClose int(11) NOT NULL default '0',
  CurrentBid int(11) NOT NULL default '0',
  BidOwnerID int(11) NOT NULL default '0',
  TurnBidMade int(11) NOT NULL default '0',
  BidMaximum int(11) NOT NULL default '0',
  PRIMARY KEY  (ID),
  KEY BidOwnerIndex (BidOwnerID),
  KEY ItemIndex (ItemID)
) TYPE=MyISAM;

CREATE TABLE campaigninfo (
  ID int(11) NOT NULL default '0',
  LOCKED datetime default NULL,
  LOCKID int(11) default NULL,
  TemplateName varchar(255) NOT NULL default '',
  Description varchar(255) NOT NULL default '',
  EarlyMapName varchar(255) NOT NULL default '',
  MidMapName varchar(255) NOT NULL default '',
  LateMapName varchar(255) NOT NULL default '',
  MissionListSize int(11) NOT NULL default '0',
  MissionList blob NOT NULL,
  RaceListSize int(11) NOT NULL default '0',
  RaceList blob NOT NULL,
  CampaignEra int(11) NOT NULL default '0',
  CampaignDifficulty int(11) NOT NULL default '0',
  TriggerPrestige int(11) NOT NULL default '0',
  TriggerMission varchar(255) NOT NULL default '',
  CampaignName varchar(255) NOT NULL default '',
  CharacterName varchar(255) NOT NULL default '',
  CharacterRace int(11) NOT NULL default '0',
  ServerPassword varchar(255) NOT NULL default '',
  CurrentTimeSize int(11) NOT NULL default '0',
  CurrentTime blob NOT NULL,
  PlayersCurrent int(11) NOT NULL default '0',
  PlayersMax int(11) NOT NULL default '0',
  PlayersLoggedOnCurrent int(11) NOT NULL default '0',
  PlayersLoggedOnMax int(11) NOT NULL default '0',
  ServerVersion varchar(255) NOT NULL default '',
  ValidClientVersion varchar(255) NOT NULL default '',
  PRIMARY KEY  (ID)
) TYPE=MyISAM;

CREATE TABLE databasedescription (
  ID int(11) NOT NULL default '0',
  LOCKED datetime default NULL,
  LOCKID int(11) default NULL,
  NextID int(11) NOT NULL default '0',
  NextLockID int(11) NOT NULL default '0',
  PRIMARY KEY  (ID)
) TYPE=MyISAM;

INSERT INTO databasedescription VALUES (1,'1969-12-31 19:00:00',0,15,1);

CREATE TABLE loginban (
  WONName varchar(255) default NULL,
  CharacterName varchar(255) default NULL,
  IPAddress varchar(255) default NULL
) TYPE=MyISAM;

CREATE TABLE mapdescription (
  ID int(11) NOT NULL default '0',
  LOCKED datetime default NULL,
  LOCKID int(11) default NULL,
  Width int(11) NOT NULL default '0',
  Height int(11) NOT NULL default '0',
  CorrectedBaseAIs int(11) NOT NULL default '0',
  PRIMARY KEY  (ID)
) TYPE=MyISAM;

CREATE TABLE maphex (
  ID int(11) NOT NULL default '0',
  LOCKED datetime default NULL,
  LOCKID int(11) default NULL,
  X int(11) NOT NULL default '0',
  Y int(11) NOT NULL default '0',
  EmpireControl int(11) NOT NULL default '0',
  CartelControl int(11) NOT NULL default '0',
  TerrainType int(11) NOT NULL default '0',
  PlanetType int(11) NOT NULL default '0',
  StarbaseType int(11) NOT NULL default '0',
  BaseEconomicPoints int(11) NOT NULL default '0',
  CurrentEconomicPoints int(11) NOT NULL default '0',
  EmpireBaseVictoryPoints int(11) NOT NULL default '0',
  CartelBaseVictoryPoints int(11) NOT NULL default '0',
  EmpireCurrentVictoryPoints int(11) NOT NULL default '0',
  CartelCurrentVictoryPoints int(11) NOT NULL default '0',
  BaseSpeedPoints double NOT NULL default '0',
  CurrentSpeedPoints double NOT NULL default '0',
  PRIMARY KEY  (ID),
  UNIQUE KEY X (X,Y)
) TYPE=MyISAM;

CREATE TABLE newsstory (
  ID int(11) NOT NULL default '0',
  LOCKED datetime default NULL,
  LOCKID int(11) default NULL,
  PersistenceLevel int(11) NOT NULL default '0',
  UrgencyLevel int(11) NOT NULL default '0',
  Category int(11) NOT NULL default '0',
  IdiomSize int(11) NOT NULL default '0',
  Idiom blob NOT NULL,
  NewsTime int(11) NOT NULL default '0',
  TimeDetail int(11) NOT NULL default '0',
  Color int(11) NOT NULL default '0',
  PRIMARY KEY  (ID)
) TYPE=MyISAM;

CREATE TABLE notify (
  ID int(11) NOT NULL default '0',
  LOCKED datetime default NULL,
  LOCKID int(11) default NULL,
  Category int(11) NOT NULL default '0',
  NotifyEvent int(11) NOT NULL default '0',
  ExtraID int(11) NOT NULL default '0',
  NameToNotifySize int(11) NOT NULL default '0',
  NameToNotify blob NOT NULL,
  DataID int(11) NOT NULL default '0',
  PRIMARY KEY  (ID)
) TYPE=MyISAM;

CREATE TABLE politicaltensionmatrix (
  ID int(11) NOT NULL default '0',
  LOCKED datetime default NULL,
  LOCKID int(11) default NULL,
  MatrixSize int(11) NOT NULL default '0',
  Matrix blob NOT NULL,
  AllyRatio int(11) NOT NULL default '0',
  NeutralRatio int(11) NOT NULL default '0',
  PRIMARY KEY  (ID)
) TYPE=MyISAM;

CREATE TABLE preparedmissions (
  ID int(11) NOT NULL default '0',
  LOCKED datetime default NULL,
  LOCKID int(11) default NULL,
  CharacterID int(11) NOT NULL default '0',
  MissionProfilesSize int(11) NOT NULL default '0',
  MissionProfiles blob NOT NULL,
  HaveTriggeredMission int(11) NOT NULL default '0',
  NearbyCharactersSize int(11) NOT NULL default '0',
  NearbyCharacters blob NOT NULL,
  NearbyHumanIDsSize int(11) NOT NULL default '0',
  NearbyHumanIDs blob NOT NULL,
  NumHumanPlayers int(11) NOT NULL default '0',
  X int(11) NOT NULL default '0',
  Y int(11) NOT NULL default '0',
  PRIMARY KEY  (ID),
  KEY CharacterIDIndex (CharacterID)
) TYPE=MyISAM;

CREATE TABLE servcharacter (
  ID int(11) NOT NULL default '0',
  LOCKED datetime default NULL,
  LOCKID int(11) default NULL,
  WONLogon varchar(255) NOT NULL default '',
  LastLoggedOn int(11) NOT NULL default '0',
  MissionsPlayedVectorSize int(11) NOT NULL default '0',
  MissionsPlayedVector blob NOT NULL,
  IPAddress varchar(15) NOT NULL default '',
  NextMissionTitle varchar(255) NOT NULL default '',
  NextMissionScore int(11) NOT NULL default '0',
  HomeWorldLocationX int(11) NOT NULL default '0',
  HomeWorldLocationY int(11) NOT NULL default '0',
  LastMustPlayLocationX int(11) NOT NULL default '0',
  LastMustPlayLocationY int(11) NOT NULL default '0',
  PreparedMissionsID int(11) NOT NULL default '0',
  OpenShipBidsSize int(11) NOT NULL default '0',
  OpenShipBids blob NOT NULL,
  CharacterName varchar(255) NOT NULL default '',
  ShipCacheVectorSize int(11) NOT NULL default '0',
  ShipCacheVector blob NOT NULL,
  CharacterRace int(11) NOT NULL default '0',
  CharacterRank int(11) NOT NULL default '0',
  CharacterPoliticalControl int(11) NOT NULL default '0',
  Flags int(11) NOT NULL default '0',
  CharacterLastBattleResult double NOT NULL default '0',
  CharacterLocationX int(11) NOT NULL default '0',
  CharacterLocationY int(11) NOT NULL default '0',
  CharacterRating int(11) NOT NULL default '0',
  Medals int(11) NOT NULL default '0',
  CharacterCurrentPrestige int(11) NOT NULL default '0',
  CharacterLifetimePrestige int(11) NOT NULL default '0',
  CharacterBattlesPlayed int(11) NOT NULL default '0',
  MissionSlotIdx int(11) NOT NULL default '0',
  MoveCompletes int(11) NOT NULL default '0',
  MoveDestinationX int(11) NOT NULL default '0',
  MoveDestinationY int(11) NOT NULL default '0',
  PRIMARY KEY  (ID),
  KEY CharNameIndex (CharacterName),
  KEY WONLogonIndex (WONLogon)
) TYPE=MyISAM;

CREATE TABLE ship (
  ID int(11) NOT NULL default '0',
  LOCKED datetime default NULL,
  LOCKID int(11) default NULL,
  Owner int(11) NOT NULL default '0',
  IsInAuction tinyint(1) NOT NULL default '0',
  Race int(11) NOT NULL default '0',
  ClassType int(11) NOT NULL default '0',
  BPV int(11) NOT NULL default '0',
  EPV int(11) NOT NULL default '0',
  ShipClassName varchar(255) NOT NULL default '',
  TurnCreated int(11) NOT NULL default '0',
  Name varchar(255) NOT NULL default '',
  DamageSize int(11) NOT NULL default '0',
  Damage blob NOT NULL,
  StoresSize int(11) NOT NULL default '0',
  Stores blob NOT NULL,
  OfficersSize int(11) NOT NULL default '0',
  Officers blob NOT NULL,
  Flags int(11) NOT NULL default '0',
  PRIMARY KEY  (ID)
) TYPE=MyISAM;

CREATE TABLE tablenames (
  ID int(11) NOT NULL default '0',
  LOCKED datetime default NULL,
  LOCKID int(11) default NULL,
  Name varchar(255) NOT NULL default '',
  PRIMARY KEY  (ID)
) TYPE=MyISAM;

INSERT INTO tablenames VALUES (2,NULL,NULL,'TableNames');
INSERT INTO tablenames VALUES (3,NULL,NULL,'TurnDescription');
INSERT INTO tablenames VALUES (4,NULL,NULL,'DatabaseDescription');
INSERT INTO tablenames VALUES (5,NULL,NULL,'MapDescription');
INSERT INTO tablenames VALUES (6,NULL,NULL,'MapHex');
INSERT INTO tablenames VALUES (7,NULL,NULL,'PoliticalTensionMatrix');
INSERT INTO tablenames VALUES (8,NULL,NULL,'ServCharacter');
INSERT INTO tablenames VALUES (9,NULL,NULL,'BidItem');
INSERT INTO tablenames VALUES (10,NULL,NULL,'Ship');
INSERT INTO tablenames VALUES (11,NULL,NULL,'CampaignInfo');
INSERT INTO tablenames VALUES (12,NULL,NULL,'Notify');
INSERT INTO tablenames VALUES (13,NULL,NULL,'NewsStory');
INSERT INTO tablenames VALUES (14,NULL,NULL,'PreparedMissions');

CREATE TABLE turndescription (
  ID int(11) NOT NULL default '0',
  LOCKED datetime default NULL,
  LOCKID int(11) default NULL,
  Turn int(11) NOT NULL default '0',
  PRIMARY KEY  (ID)
) TYPE=MyISAM;
