/*
 * FleetPickContainer.h
 *
 * Reads the output from a FleetPick run.
 *
 * (C) 2001 MagnumMan-iCoP (James E. King, III)
 */

#include "SerializableShipDesc.h"

#ifndef _fpc
#define _fpc

class FleetPickContainer
{
private:
	int						c;
	SerializableShipDesc	s[3];

public:
	FleetPickContainer()
	{
		c = 0;

		FILE *fp = fopen("C:\\Orion.FLT", "rb");
		if (fp)
		{
			int version;
			if (fread(&version, sizeof(int), 1, fp) == 1)
			{
				if (version == SSD_REVISION)
				{
					int count;
					if (fread(&count, sizeof(int), 1, fp) == 1)
					{
						c = count;
						
						if (count--)
							s[0].Read(fp);
						if (count--)
							s[1].Read(fp);
						if (count--)
							s[2].Read(fp);
					}

					fclose(fp);
				}
				else
					MessageBox(0, "FleetPick and Script are incompatible releases.", "Error", MB_OK | MB_ICONEXCLAMATION);
			}
		}
	}

	~FleetPickContainer() { }

	inline int					getShipCount(void) { return c; }
	inline SerializableShipDesc getSSD(int ord)    { return s[ord - 1]; }
										// ord is 1 based
};

#endif
