/*
 * SerializableShipDesc.cpp
 *
 * Defines a ship selected with FleetPick.
 *
 * (C) 2001 MagnumMan-iCoP (James E. King, III)
 */

#ifndef _ssd
#define _ssd

#define SSD_REVISION	1		// Used to make sure struct changes are noticed

class SerializableShipDesc
{
public:

	char	shipCode[16];
	int		bpv_base;
	int		bpv_curr;			// Current adjusted BPV

	int		shuttles;			// number of shuttles the ship should have at startup
	int		marines;			// etc
	int		mines;
	int		repairs;

	int		drone_size;			// 1 = Type I (small); 4 = Type IV (heavy)
	int		drone_speed;		// 1 = slow; 2 = medium; 3 = large
	int		drone_reloads;		// 1 = 1 reload, ..., 4 = 4 reloads
	int		drone_count;		// more useful for the API

	char	fighter_bay_1[40];	// Fighter ship call name
	int		fighter_count_1;	// 1 through 4

	char	fighter_bay_2[40];	// Fighter ship call name
	int		fighter_count_2;	// 1 through 4

	char	fighter_bay_3[40];	// Fighter ship call name
	int		fighter_count_3;	// 1 through 4

	char	fighter_bay_4[40];	// Fighter ship call name
	int		fighter_count_4;	// 1 through 4

	SerializableShipDesc()
	{
		Reset();
	}

	~SerializableShipDesc()
	{
	}

	inline void Reset(void)
	{
		memset(this, 0, sizeof(SerializableShipDesc));
	}
	
	inline bool Write(FILE *fp)
	{
		return fwrite(this, sizeof(SerializableShipDesc), 1, fp) == 1;
	}

	inline bool Read(FILE *fp)
	{
		return fread(this,  sizeof(SerializableShipDesc), 1, fp) == 1;
	}

	inline void	Dump(FILE *fp)
	{
		fprintf(fp, "SSD Dump:\n");
		fprintf(fp, "Ship: %s BPV %d Adjusted %d\n", shipCode, bpv_base, bpv_curr);

		fprintf(fp, "Shuttles: %d\n Marines: %d\n   Mines: %d\n Repairs: %d\n",
			shuttles, marines, mines, repairs);

		fprintf(fp, "Drone size: %d\n      speed: %d\n     reloads: %d\n", drone_size, drone_speed, drone_reloads);

		fprintf(fp, "Fighter 1: %d %s\n", fighter_count_1, fighter_bay_1);
		fprintf(fp, "Fighter 2: %d %s\n", fighter_count_2, fighter_bay_2);
		fprintf(fp, "Fighter 3: %d %s\n", fighter_count_3, fighter_bay_3);
		fprintf(fp, "Fighter 4: %d %s\n", fighter_count_4, fighter_bay_4);
	}		
};

#endif
